package io.vertx.mutiny.core.shareddata;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Map;

/**
 * Local maps can be used to share data safely in a single Vert.x instance.
 * <p>
 * By default the map allows immutable keys and values.
 * Custom keys and values should implement {@link io.vertx.core.shareddata.Shareable} interface. The map returns their copies.
 * <p>
 * This ensures there is no shared access to mutable state from different threads (e.g. different event loops) in the
 * Vert.x instance, and means you don't have to protect access to that state using synchronization or locks.
 * <p>
 *
 * Since the version 3.4, this class extends the  interface. However some methods are only accessible in Java.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.LocalMap original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.shareddata.LocalMap.class)
public class LocalMap<K,V> {

  public static final io.smallrye.mutiny.vertx.TypeArg<LocalMap> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new LocalMap((io.vertx.core.shareddata.LocalMap) obj),
    LocalMap::getDelegate
  );

  private final io.vertx.core.shareddata.LocalMap<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public LocalMap(io.vertx.core.shareddata.LocalMap delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public LocalMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.core.shareddata.LocalMap)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public LocalMap(io.vertx.core.shareddata.LocalMap delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  LocalMap() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.shareddata.LocalMap getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LocalMap that = (LocalMap) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param key the key
   * @return the value, or null if none
   */
  public V get(java.lang.Object key) { 
    V ret = (V)__typeArg_1.wrap(delegate.get(key));
    return ret;
  }

  /**
   * @param key the key
   * @param value the value
   * @return return the old value, or null if none
   */
  public V put(K key, V value) { 
    V ret = (V)__typeArg_1.wrap(delegate.put(__typeArg_0.<K>unwrap(key), __typeArg_1.<V>unwrap(value)));
    return ret;
  }

  /**
   * @param key the key
   * @return the old value
   */
  public V remove(java.lang.Object key) { 
    V ret = (V)__typeArg_1.wrap(delegate.remove(key));
    return ret;
  }

  /**
   */
  public void clear() { 
    delegate.clear();
  }

  /**
   * @return the number of entries in the map
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  /**
   * @return true if there are zero entries in the map
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @param key the key
   * @param value the value
   * @return the old value or null, if none
   */
  public V putIfAbsent(K key, V value) { 
    V ret = (V)__typeArg_1.wrap(delegate.putIfAbsent(__typeArg_0.<K>unwrap(key), __typeArg_1.<V>unwrap(value)));
    return ret;
  }

  /**
   * @param key the key
   * @param value the value
   * @return true if removed
   */
  public boolean removeIfPresent(K key, V value) { 
    boolean ret = delegate.removeIfPresent(__typeArg_0.<K>unwrap(key), __typeArg_1.<V>unwrap(value));
    return ret;
  }

  /**
   * @param key the key
   * @param oldValue the old value
   * @param newValue the new value
   * @return true if removed
   */
  public boolean replaceIfPresent(K key, V oldValue, V newValue) { 
    boolean ret = delegate.replaceIfPresent(__typeArg_0.<K>unwrap(key), __typeArg_1.<V>unwrap(oldValue), __typeArg_1.<V>unwrap(newValue));
    return ret;
  }

  /**
   * @param key the key
   * @param value the new value
   * @return the old value
   */
  public V replace(K key, V value) { 
    V ret = (V)__typeArg_1.wrap(delegate.replace(__typeArg_0.<K>unwrap(key), __typeArg_1.<V>unwrap(value)));
    return ret;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @param key key whose presence in this map is to be tested
   * @return <code>true</code> if this map contains a mapping for the specified key
   */
  public boolean containsKey(java.lang.Object key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * @param value value whose presence in this map is to be tested
   * @return @{code true} if this map maps one or more keys to the specified value
   */
  public boolean containsValue(java.lang.Object value) { 
    boolean ret = delegate.containsValue(value);
    return ret;
  }

  /**
   * @param key the key whose associated value is to be returned
   * @param defaultValue the default mapping of the key
   * @return the value to which the specified key is mapped, or <code>defaultValue</code> if this map contains no mapping for the key
   */
  public V getOrDefault(java.lang.Object key, V defaultValue) { 
    V ret = (V)__typeArg_1.wrap(delegate.getOrDefault(key, __typeArg_1.<V>unwrap(defaultValue)));
    return ret;
  }

  public static <K,V>LocalMap<K,V> newInstance(io.vertx.core.shareddata.LocalMap arg) {
    return arg != null ? new LocalMap<K,V>(arg) : null;
  }


  public static <K,V>LocalMap<K,V> newInstance(io.vertx.core.shareddata.LocalMap arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new LocalMap<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
