package io.vertx.mutiny.core.datagram;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A received datagram packet (UDP) which contains the data and information about the sender of the data itself.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.datagram.DatagramPacket original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.datagram.DatagramPacket.class)
public class DatagramPacket {

  public static final io.smallrye.mutiny.vertx.TypeArg<DatagramPacket> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new DatagramPacket((io.vertx.core.datagram.DatagramPacket) obj),
    DatagramPacket::getDelegate
  );

  private final io.vertx.core.datagram.DatagramPacket delegate;
  
  public DatagramPacket(io.vertx.core.datagram.DatagramPacket delegate) {
    this.delegate = delegate;
  }

  public DatagramPacket(Object delegate) {
    this.delegate = (io.vertx.core.datagram.DatagramPacket)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  DatagramPacket() {
    this.delegate = null;
  }

  public io.vertx.core.datagram.DatagramPacket getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DatagramPacket that = (DatagramPacket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the address of the sender
   */
  public io.vertx.mutiny.core.net.SocketAddress sender() { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.sender());
    return ret;
  }

  /**
   * @return the data
   */
  public io.vertx.mutiny.core.buffer.Buffer data() { 
    io.vertx.mutiny.core.buffer.Buffer ret = io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.data());
    return ret;
  }

  public static  DatagramPacket newInstance(io.vertx.core.datagram.DatagramPacket arg) {
    return arg != null ? new DatagramPacket(arg) : null;
  }

}
