/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.eventbus;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.eventbus.Message;
import java.util.function.Consumer;
import java.util.function.Function;

@MutinyGen(value=io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T>
implements io.vertx.mutiny.core.streams.WriteStream<T> {
    public static final TypeArg<MessageProducer> __TYPE_ARG = new TypeArg(obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer)obj), MessageProducer::getDelegate);
    private final io.vertx.core.eventbus.MessageProducer<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private WriteStreamSubscriber<T> subscriber;
    public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = 1000;

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    MessageProducer() {
        this.delegate = null;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public io.vertx.core.eventbus.MessageProducer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageProducer that = (MessageProducer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<T> toSubscriber() {
        if (this.subscriber == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.subscriber;
    }

    private void __end(T data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(this.__typeArg_0.unwrap(data), handler);
    }

    @Override
    public Uni<Void> end(T data) {
        return AsyncResultUni.toUni(handler -> this.__end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(T data) {
        return (Void)this.end(data).await().indefinitely();
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Deprecated
    private <R> MessageProducer<T> __send(T message, final Handler<AsyncResult<Message<R>>> replyHandler) {
        MessageProducer<T> ret = MessageProducer.newInstance(this.delegate.send(this.__typeArg_0.unwrap(message), new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
                if (ar.succeeded()) {
                    replyHandler.handle((Object)Future.succeededFuture(Message.newInstance((io.vertx.core.eventbus.Message)ar.result(), TypeArg.unknown())));
                } else {
                    replyHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }), this.__typeArg_0);
        return ret;
    }

    @Deprecated
    public <R> Uni<Message<R>> send(T message) {
        return AsyncResultUni.toUni(handler -> this.__send(message, (Handler)handler));
    }

    @Deprecated
    public <R> Message<R> sendAndAwait(T message) {
        return (Message)this.send(message).await().indefinitely();
    }

    private MessageProducer<T> __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MessageProducer<T> exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private MessageProducer<T> __write(T data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(this.__typeArg_0.unwrap(data), handler);
        return this;
    }

    @Override
    public Uni<Void> write(T data) {
        return AsyncResultUni.toUni(handler -> this.__write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(T data) {
        return (Void)this.write(data).await().indefinitely();
    }

    @Override
    public MessageProducer<T> setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    private MessageProducer<T> __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public MessageProducer<T> drainHandler(Consumer<Void> handler) {
        return this.__drainHandler(handler != null ? handler::accept : null);
    }

    public MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.delegate.deliveryOptions(options);
        return this;
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    private void __end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.__end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void endAndForget(T data) {
        this.delegate.end(this.__typeArg_0.unwrap(data));
    }

    @Deprecated
    public MessageProducer<T> sendAndForget(T message) {
        MessageProducer<T> ret = MessageProducer.newInstance(this.delegate.send(this.__typeArg_0.unwrap(message)), this.__typeArg_0);
        return ret;
    }

    public MessageProducer<T> writeAndForget(T data) {
        this.delegate.write(this.__typeArg_0.unwrap(data));
        return this;
    }

    public void endAndForget() {
        this.delegate.end();
    }

    public void closeAndForget() {
        this.delegate.close();
    }

    public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
        return arg != null ? new MessageProducer<T>(arg) : null;
    }

    public static <T> MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
    }
}

