/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.dns;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.dns.MxRecord;
import io.vertx.mutiny.core.dns.SrvRecord;
import java.util.List;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    DnsClient() {
        this.delegate = null;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private DnsClient __lookup(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name, handler);
        return this;
    }

    public Uni<String> lookup(String name) {
        return AsyncResultUni.toUni(handler -> this.__lookup(name, (Handler<AsyncResult<String>>)handler));
    }

    public String lookupAndAwait(String name) {
        return (String)this.lookup(name).await().indefinitely();
    }

    private DnsClient __lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name, handler);
        return this;
    }

    public Uni<String> lookup4(String name) {
        return AsyncResultUni.toUni(handler -> this.__lookup4(name, (Handler<AsyncResult<String>>)handler));
    }

    public String lookup4AndAwait(String name) {
        return (String)this.lookup4(name).await().indefinitely();
    }

    private DnsClient __lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name, handler);
        return this;
    }

    public Uni<String> lookup6(String name) {
        return AsyncResultUni.toUni(handler -> this.__lookup6(name, (Handler<AsyncResult<String>>)handler));
    }

    public String lookup6AndAwait(String name) {
        return (String)this.lookup6(name).await().indefinitely();
    }

    private DnsClient __resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name, handler);
        return this;
    }

    public Uni<List<String>> resolveA(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveAAndAwait(String name) {
        return (List)this.resolveA(name).await().indefinitely();
    }

    private DnsClient __resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name, handler);
        return this;
    }

    public Uni<List<String>> resolveAAAA(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveAAAA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveAAAAAndAwait(String name) {
        return (List)this.resolveAAAA(name).await().indefinitely();
    }

    private DnsClient __resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name, handler);
        return this;
    }

    public Uni<List<String>> resolveCNAME(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveCNAME(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveCNAMEAndAwait(String name) {
        return (List)this.resolveCNAME(name).await().indefinitely();
    }

    private DnsClient __resolveMX(String name, final Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.MxRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.MxRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<List<MxRecord>> resolveMX(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveMX(name, (Handler<AsyncResult<List<MxRecord>>>)handler));
    }

    public List<MxRecord> resolveMXAndAwait(String name) {
        return (List)this.resolveMX(name).await().indefinitely();
    }

    private DnsClient __resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name, handler);
        return this;
    }

    public Uni<List<String>> resolveTXT(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveTXT(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveTXTAndAwait(String name) {
        return (List)this.resolveTXT(name).await().indefinitely();
    }

    private DnsClient __resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name, handler);
        return this;
    }

    public Uni<String> resolvePTR(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolvePTR(name, (Handler<AsyncResult<String>>)handler));
    }

    public String resolvePTRAndAwait(String name) {
        return (String)this.resolvePTR(name).await().indefinitely();
    }

    private DnsClient __resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name, handler);
        return this;
    }

    public Uni<List<String>> resolveNS(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveNS(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveNSAndAwait(String name) {
        return (List)this.resolveNS(name).await().indefinitely();
    }

    private DnsClient __resolveSRV(String name, final Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.SrvRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.SrvRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<List<SrvRecord>> resolveSRV(String name) {
        return AsyncResultUni.toUni(handler -> this.__resolveSRV(name, (Handler<AsyncResult<List<SrvRecord>>>)handler));
    }

    public List<SrvRecord> resolveSRVAndAwait(String name) {
        return (List)this.resolveSRV(name).await().indefinitely();
    }

    private DnsClient __reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    public Uni<String> reverseLookup(String ipaddress) {
        return AsyncResultUni.toUni(handler -> this.__reverseLookup(ipaddress, (Handler<AsyncResult<String>>)handler));
    }

    public String reverseLookupAndAwait(String ipaddress) {
        return (String)this.reverseLookup(ipaddress).await().indefinitely();
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

