/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.datagram;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.datagram.DatagramPacket;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements ReadStream<DatagramPacket>,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    static final TypeArg<Buffer> TYPE_ARG_1 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    static final TypeArg<DatagramPacket> TYPE_ARG_0 = new TypeArg(o1 -> DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private Multi<DatagramPacket> multi;

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    DatagramSocket() {
        this.delegate = null;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Override
    public Pipe<DatagramPacket> pipe() {
        Pipe<DatagramPacket> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    private void __pipeTo(WriteStream<DatagramPacket> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(WriteStream<DatagramPacket> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<DatagramPacket> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    private DatagramSocket __send(Buffer packet, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(packet.getDelegate(), port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> send(Buffer packet, int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__send(packet, port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket sendAndAwait(Buffer packet, int port, String host) {
        return (DatagramSocket)this.send(packet, port, host).await().indefinitely();
    }

    public WriteStream<Buffer> sender(int port, String host) {
        WriteStream<Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), TYPE_ARG_1);
        return ret;
    }

    private DatagramSocket __send(String str, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(str, port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> send(String str, int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__send(str, port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket sendAndAwait(String str, int port, String host) {
        return (DatagramSocket)this.send(str, port, host).await().indefinitely();
    }

    private DatagramSocket __send(String str, String enc, int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.send(str, enc, port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> send(String str, String enc, int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__send(str, enc, port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket sendAndAwait(String str, String enc, int port, String host) {
        return (DatagramSocket)this.send(str, enc, port, host).await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    private DatagramSocket __listenMulticastGroup(String multicastAddress, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> listenMulticastGroup(String multicastAddress) {
        return AsyncResultUni.toUni(handler -> this.__listenMulticastGroup(multicastAddress, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket listenMulticastGroupAndAwait(String multicastAddress) {
        return (DatagramSocket)this.listenMulticastGroup(multicastAddress).await().indefinitely();
    }

    private DatagramSocket __listenMulticastGroup(String multicastAddress, String networkInterface, String source, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> listenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultUni.toUni(handler -> this.__listenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket listenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) {
        return (DatagramSocket)this.listenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
    }

    private DatagramSocket __unlistenMulticastGroup(String multicastAddress, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> unlistenMulticastGroup(String multicastAddress) {
        return AsyncResultUni.toUni(handler -> this.__unlistenMulticastGroup(multicastAddress, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket unlistenMulticastGroupAndAwait(String multicastAddress) {
        return (DatagramSocket)this.unlistenMulticastGroup(multicastAddress).await().indefinitely();
    }

    private DatagramSocket __unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultUni.toUni(handler -> this.__unlistenMulticastGroup(multicastAddress, networkInterface, source, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket unlistenMulticastGroupAndAwait(String multicastAddress, String networkInterface, String source) {
        return (DatagramSocket)this.unlistenMulticastGroup(multicastAddress, networkInterface, source).await().indefinitely();
    }

    private DatagramSocket __blockMulticastGroup(String multicastAddress, String sourceToBlock, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return AsyncResultUni.toUni(handler -> this.__blockMulticastGroup(multicastAddress, sourceToBlock, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket blockMulticastGroupAndAwait(String multicastAddress, String sourceToBlock) {
        return (DatagramSocket)this.blockMulticastGroup(multicastAddress, sourceToBlock).await().indefinitely();
    }

    private DatagramSocket __blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return AsyncResultUni.toUni(handler -> this.__blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket blockMulticastGroupAndAwait(String multicastAddress, String networkInterface, String sourceToBlock) {
        return (DatagramSocket)this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).await().indefinitely();
    }

    private DatagramSocket __listen(int port, String host, final Handler<AsyncResult<DatagramSocket>> handler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.datagram.DatagramSocket>>(){

            public void handle(AsyncResult<io.vertx.core.datagram.DatagramSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<DatagramSocket> listen(int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__listen(port, host, (Handler<AsyncResult<DatagramSocket>>)handler));
    }

    public DatagramSocket listenAndAwait(int port, String host) {
        return (DatagramSocket)this.listen(port, host).await().indefinitely();
    }

    public DatagramSocket pause() {
        this.delegate.pause();
        return this;
    }

    public DatagramSocket resume() {
        this.delegate.resume();
        return this;
    }

    public DatagramSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private DatagramSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public DatagramSocket endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    private DatagramSocket __handler(final Handler<DatagramPacket> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.datagram.DatagramPacket>(){

            public void handle(io.vertx.core.datagram.DatagramPacket event) {
                handler.handle((Object)DatagramPacket.newInstance(event));
            }
        });
        return this;
    }

    public DatagramSocket handler(Consumer<DatagramPacket> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    private DatagramSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public DatagramSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    public void pipeToAndForget(WriteStream<DatagramPacket> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    public void closeAndForget() {
        this.delegate.close();
    }

    @Override
    public synchronized Multi<DatagramPacket> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<DatagramPacket> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<DatagramPacket> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

