/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.net;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements ReadStream<Buffer>,
io.vertx.mutiny.core.streams.WriteStream<Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private Multi<Buffer> multi;

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    NetSocket() {
        this.delegate = null;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    private void __end(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    @Override
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return (Void)this.end(data).await().indefinitely();
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), Buffer.__TYPE_ARG);
        return ret;
    }

    private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    private NetSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public NetSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private NetSocket __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private NetSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    private NetSocket __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public NetSocket drainHandler(Consumer<Void> handler) {
        return this.__drainHandler(handler != null ? handler::accept : null);
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    private NetSocket __write(String str, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(str, handler);
        return this;
    }

    @Override
    public Uni<Void> write(String str) {
        return AsyncResultUni.toUni(handler -> this.__write(str, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(String str) {
        return (Void)this.write(str).await().indefinitely();
    }

    private NetSocket __write(String str, String enc, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(str, enc, handler);
        return this;
    }

    public Uni<Void> write(String str, String enc) {
        return AsyncResultUni.toUni(handler -> this.__write(str, enc, (Handler<AsyncResult<Void>>)handler));
    }

    public Void writeAndAwait(String str, String enc) {
        return (Void)this.write(str, enc).await().indefinitely();
    }

    private NetSocket __write(Buffer message, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(message.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> write(Buffer message) {
        return AsyncResultUni.toUni(handler -> this.__write(message, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer message) {
        return (Void)this.write(message).await().indefinitely();
    }

    private NetSocket __sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, resultHandler);
        return this;
    }

    public Uni<Void> sendFile(String filename) {
        return AsyncResultUni.toUni(handler -> this.__sendFile(filename, (Handler<AsyncResult<Void>>)handler));
    }

    public Void sendFileAndAwait(String filename) {
        return (Void)this.sendFile(filename).await().indefinitely();
    }

    private NetSocket __sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, resultHandler);
        return this;
    }

    public Uni<Void> sendFile(String filename, long offset) {
        return AsyncResultUni.toUni(handler -> this.__sendFile(filename, offset, (Handler<AsyncResult<Void>>)handler));
    }

    public Void sendFileAndAwait(String filename, long offset) {
        return (Void)this.sendFile(filename, offset).await().indefinitely();
    }

    private NetSocket __sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.sendFile(filename, offset, length, resultHandler);
        return this;
    }

    public Uni<Void> sendFile(String filename, long offset, long length) {
        return AsyncResultUni.toUni(handler -> this.__sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)handler));
    }

    public Void sendFileAndAwait(String filename, long offset, long length) {
        return (Void)this.sendFile(filename, offset, length).await().indefinitely();
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    private void __end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.__end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private NetSocket __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket closeHandler(Consumer<Void> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    private NetSocket __upgradeToSsl(Handler<Void> handler) {
        this.delegate.upgradeToSsl(handler);
        return this;
    }

    public NetSocket upgradeToSsl(Consumer<Void> handler) {
        return this.__upgradeToSsl(handler != null ? handler::accept : null);
    }

    private NetSocket __upgradeToSsl(String serverName, Handler<Void> handler) {
        this.delegate.upgradeToSsl(serverName, handler);
        return this;
    }

    public NetSocket upgradeToSsl(String serverName, Consumer<Void> handler) {
        return this.__upgradeToSsl(serverName, handler != null ? handler::accept : null);
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

