/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.WebSocketBase;
import io.vertx.mutiny.core.http.WebSocketFrame;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.http.WebSocket.class)
public class WebSocket
implements WebSocketBase {
    public static final TypeArg<WebSocket> __TYPE_ARG = new TypeArg(obj -> new WebSocket((io.vertx.core.http.WebSocket)obj), WebSocket::getDelegate);
    private final io.vertx.core.http.WebSocket delegate;
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private Multi<Buffer> multi;

    public WebSocket(io.vertx.core.http.WebSocket delegate) {
        this.delegate = delegate;
    }

    WebSocket() {
        this.delegate = null;
    }

    public io.vertx.core.http.WebSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocket that = (WebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    private void __end(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    @Override
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return (Void)this.end(data).await().indefinitely();
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), Buffer.__TYPE_ARG);
        return ret;
    }

    private void __pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public WebSocketBase writePing(Buffer data) {
        this.delegate.writePing(data.getDelegate());
        return this;
    }

    @Override
    public WebSocketBase writePong(Buffer data) {
        this.delegate.writePong(data.getDelegate());
        return this;
    }

    private WebSocketBase __textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Consumer<String> handler) {
        return this.__textMessageHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __binaryMessageHandler(final Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(Consumer<Buffer> handler) {
        return this.__binaryMessageHandler(handler != null ? handler::accept : null);
    }

    private WebSocketBase __pongHandler(final Handler<Buffer> handler) {
        this.delegate.pongHandler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(Consumer<Buffer> handler) {
        return this.__pongHandler(handler != null ? handler::accept : null);
    }

    private void __end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.__end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    private void __close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    @Override
    public Uni<Void> close(short statusCode) {
        return AsyncResultUni.toUni(handler -> this.__close(statusCode, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait(short statusCode) {
        return (Void)this.close(statusCode).await().indefinitely();
    }

    private void __close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    @Override
    public Uni<Void> close(short statusCode, String reason) {
        return AsyncResultUni.toUni(handler -> this.__close(statusCode, reason, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait(short statusCode, String reason) {
        return (Void)this.close(statusCode, reason).await().indefinitely();
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    private WebSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private WebSocket __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocket handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Override
    public WebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private WebSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocket endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    private WebSocket __write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return (Void)this.write(data).await().indefinitely();
    }

    @Override
    public WebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    private WebSocket __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public WebSocket drainHandler(Consumer<Void> handler) {
        return this.__drainHandler(handler != null ? handler::accept : null);
    }

    private WebSocket __writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> writeFrame(WebSocketFrame frame) {
        return AsyncResultUni.toUni(handler -> this.__writeFrame(frame, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeFrameAndAwait(WebSocketFrame frame) {
        return (Void)this.writeFrame(frame).await().indefinitely();
    }

    private WebSocket __writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, handler);
        return this;
    }

    @Override
    public Uni<Void> writeFinalTextFrame(String text) {
        return AsyncResultUni.toUni(handler -> this.__writeFinalTextFrame(text, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeFinalTextFrameAndAwait(String text) {
        return (Void)this.writeFinalTextFrame(text).await().indefinitely();
    }

    private WebSocket __writeFinalBinaryFrame(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> writeFinalBinaryFrame(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__writeFinalBinaryFrame(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeFinalBinaryFrameAndAwait(Buffer data) {
        return (Void)this.writeFinalBinaryFrame(data).await().indefinitely();
    }

    private WebSocket __writeBinaryMessage(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> writeBinaryMessage(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__writeBinaryMessage(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeBinaryMessageAndAwait(Buffer data) {
        return (Void)this.writeBinaryMessage(data).await().indefinitely();
    }

    private WebSocket __writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, handler);
        return this;
    }

    @Override
    public Uni<Void> writeTextMessage(String text) {
        return AsyncResultUni.toUni(handler -> this.__writeTextMessage(text, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeTextMessageAndAwait(String text) {
        return (Void)this.writeTextMessage(text).await().indefinitely();
    }

    private WebSocket __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocket closeHandler(Consumer<Void> handler) {
        return this.__closeHandler(handler != null ? handler::accept : null);
    }

    private WebSocket __frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle((Object)WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocket frameHandler(Consumer<WebSocketFrame> handler) {
        return this.__frameHandler(handler != null ? handler::accept : null);
    }

    @Override
    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
        return arg != null ? new WebSocket(arg) : null;
    }
}

