/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.webauthn;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider;
import io.vertx.mutiny.ext.auth.webauthn.MetaDataService;
import java.util.List;
import java.util.function.Function;

@MutinyGen(value=io.vertx.ext.auth.webauthn.WebAuthn.class)
public class WebAuthn
extends AuthenticationProvider
implements MutinyDelegate {
    public static final TypeArg<WebAuthn> __TYPE_ARG = new TypeArg(obj -> new WebAuthn((io.vertx.ext.auth.webauthn.WebAuthn)obj), WebAuthn::getDelegate);
    private final io.vertx.ext.auth.webauthn.WebAuthn delegate;

    public WebAuthn(io.vertx.ext.auth.webauthn.WebAuthn delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public WebAuthn(Object delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)((io.vertx.ext.auth.webauthn.WebAuthn)delegate));
        this.delegate = (io.vertx.ext.auth.webauthn.WebAuthn)delegate;
    }

    WebAuthn() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.webauthn.WebAuthn getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WebAuthn that = (WebAuthn)((Object)o);
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static WebAuthn create(io.vertx.mutiny.core.Vertx vertx) {
        WebAuthn ret = WebAuthn.newInstance(io.vertx.ext.auth.webauthn.WebAuthn.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static WebAuthn create(io.vertx.mutiny.core.Vertx vertx, WebAuthnOptions options) {
        WebAuthn ret = WebAuthn.newInstance(io.vertx.ext.auth.webauthn.WebAuthn.create((Vertx)vertx.getDelegate(), (WebAuthnOptions)options));
        return ret;
    }

    @CheckReturnValue
    public Uni<JsonObject> createCredentialsOptions(JsonObject user) {
        return AsyncResultUni.toUni(handler -> this.delegate.createCredentialsOptions(user, handler));
    }

    public JsonObject createCredentialsOptionsAndAwait(JsonObject user) {
        return (JsonObject)this.createCredentialsOptions(user).await().indefinitely();
    }

    @Fluent
    public WebAuthn createCredentialsOptionsAndForget(JsonObject user) {
        this.createCredentialsOptions(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> getCredentialsOptions(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.getCredentialsOptions(name, handler));
    }

    public JsonObject getCredentialsOptionsAndAwait(String name) {
        return (JsonObject)this.getCredentialsOptions(name).await().indefinitely();
    }

    @Fluent
    public WebAuthn getCredentialsOptionsAndForget(String name) {
        this.getCredentialsOptions(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public WebAuthn authenticatorFetcher(final Function<Authenticator, Uni<List<Authenticator>>> fetcher) {
        this.delegate.authenticatorFetcher((Function)new Function<Authenticator, Future<List<Authenticator>>>(){

            @Override
            public Future<List<Authenticator>> apply(Authenticator arg) {
                return UniHelper.toFuture((Uni)((Uni)fetcher.apply(arg)));
            }
        });
        return this;
    }

    @Fluent
    public WebAuthn authenticatorUpdater(final Function<Authenticator, Uni<Void>> updater) {
        this.delegate.authenticatorUpdater((Function)new Function<Authenticator, Future<Void>>(){

            @Override
            public Future<Void> apply(Authenticator arg) {
                return UniHelper.toFuture((Uni)((Uni)updater.apply(arg)));
            }
        });
        return this;
    }

    public MetaDataService metaDataService() {
        MetaDataService ret = MetaDataService.newInstance(this.delegate.metaDataService());
        return ret;
    }

    public static WebAuthn newInstance(io.vertx.ext.auth.webauthn.WebAuthn arg) {
        return arg != null ? new WebAuthn(arg) : null;
    }
}

