/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.mongo;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;

@MutinyGen(value=io.vertx.ext.auth.mongo.MongoUserUtil.class)
public class MongoUserUtil {
    public static final TypeArg<MongoUserUtil> __TYPE_ARG = new TypeArg(obj -> new MongoUserUtil((io.vertx.ext.auth.mongo.MongoUserUtil)obj), MongoUserUtil::getDelegate);
    private final io.vertx.ext.auth.mongo.MongoUserUtil delegate;

    public MongoUserUtil(io.vertx.ext.auth.mongo.MongoUserUtil delegate) {
        this.delegate = delegate;
    }

    public MongoUserUtil(Object delegate) {
        this.delegate = (io.vertx.ext.auth.mongo.MongoUserUtil)delegate;
    }

    MongoUserUtil() {
        this.delegate = null;
    }

    public io.vertx.ext.auth.mongo.MongoUserUtil getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoUserUtil that = (MongoUserUtil)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static MongoUserUtil create(io.vertx.mutiny.ext.mongo.MongoClient client) {
        MongoUserUtil ret = MongoUserUtil.newInstance(io.vertx.ext.auth.mongo.MongoUserUtil.create((MongoClient)client.getDelegate()));
        return ret;
    }

    public static MongoUserUtil create(io.vertx.mutiny.ext.mongo.MongoClient client, MongoAuthenticationOptions authenticationOptions, MongoAuthorizationOptions authorizationOptions) {
        MongoUserUtil ret = MongoUserUtil.newInstance(io.vertx.ext.auth.mongo.MongoUserUtil.create((MongoClient)client.getDelegate(), (MongoAuthenticationOptions)authenticationOptions, (MongoAuthorizationOptions)authorizationOptions));
        return ret;
    }

    @CheckReturnValue
    public Uni<String> createUser(String username, String password) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createUser(username, password, resultHandler));
    }

    public String createUserAndAwait(String username, String password) {
        return (String)this.createUser(username, password).await().indefinitely();
    }

    @Fluent
    public MongoUserUtil createUserAndForget(String username, String password) {
        this.createUser(username, password).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> createHashedUser(String username, String hash) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createHashedUser(username, hash, resultHandler));
    }

    public String createHashedUserAndAwait(String username, String hash) {
        return (String)this.createHashedUser(username, hash).await().indefinitely();
    }

    @Fluent
    public MongoUserUtil createHashedUserAndForget(String username, String hash) {
        this.createHashedUser(username, hash).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> createUserRolesAndPermissions(String username, List<String> roles, List<String> permissions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createUserRolesAndPermissions(username, roles, permissions, resultHandler));
    }

    public String createUserRolesAndPermissionsAndAwait(String username, List<String> roles, List<String> permissions) {
        return (String)this.createUserRolesAndPermissions(username, roles, permissions).await().indefinitely();
    }

    @Fluent
    public MongoUserUtil createUserRolesAndPermissionsAndForget(String username, List<String> roles, List<String> permissions) {
        this.createUserRolesAndPermissions(username, roles, permissions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public static MongoUserUtil newInstance(io.vertx.ext.auth.mongo.MongoUserUtil arg) {
        return arg != null ? new MongoUserUtil(arg) : null;
    }
}

