/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.Cancellable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class UniSubscribeToCompletionStage {
    public static <T> CompletableFuture<T> subscribe(Uni<T> uni, Context context) {
        AtomicReference<Cancellable> cancellable = new AtomicReference<Cancellable>();
        CompletableFuture future = Infrastructure.wrapCompletableFuture(new CompletableFuture());
        future.whenComplete((val, x) -> {
            Cancellable c;
            if (x instanceof CancellationException && future.isCancelled() && (c = (Cancellable)cancellable.get()) != null) {
                c.cancel();
            }
        });
        cancellable.set(uni.subscribe().with(context, future::complete, future::completeExceptionally));
        return future;
    }
}

