/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public final class MultiOnSubscribeCall<T>
extends AbstractMultiOperator<T, T> {
    private final Function<? super Flow.Subscription, Uni<?>> onSubscribe;

    public MultiOnSubscribeCall(Multi<? extends T> upstream, Function<? super Flow.Subscription, Uni<?>> onSubscribe) {
        super(upstream);
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("Subscriber must not be `null`");
        }
        this.upstream.subscribe().withSubscriber(new OnSubscribeSubscriber(actual));
    }

    private final class OnSubscribeSubscriber
    extends MultiOperatorProcessor<T, T> {
        private final ReentrantLock lock;
        private Throwable failure;
        private boolean terminatedEarly;
        private boolean uniHasTerminated;

        OnSubscribeSubscriber(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.lock = new ReentrantLock();
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.compareAndSetUpstreamSubscription(null, s)) {
                try {
                    Uni<?> uni = Objects.requireNonNull(MultiOnSubscribeCall.this.onSubscribe.apply(s), "The produced Uni must not be `null`");
                    uni.subscribe().with(ignored -> this.uniCompleted(), err -> this.uniFailed((Throwable)err));
                }
                catch (Throwable e) {
                    Subscriptions.fail(this.downstream, e);
                    this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                }
            } else {
                s.cancel();
            }
        }

        @Override
        public void onFailure(Throwable throwable) {
            this.lock.lock();
            if (!this.uniHasTerminated) {
                this.terminatedEarly = true;
                this.failure = throwable;
                this.lock.unlock();
            } else {
                this.lock.unlock();
                super.onFailure(throwable);
            }
        }

        @Override
        public void onCompletion() {
            this.lock.lock();
            if (!this.uniHasTerminated) {
                this.terminatedEarly = true;
                this.lock.unlock();
            } else {
                this.lock.unlock();
                super.onCompletion();
            }
        }

        private void uniFailed(Throwable failure) {
            this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
            this.lock.lock();
            try {
                this.uniHasTerminated = true;
                if (this.failure == null) {
                    this.failure = failure;
                } else {
                    this.failure.addSuppressed(failure);
                }
            }
            finally {
                this.lock.unlock();
            }
            Subscriptions.fail(this.downstream, this.failure);
        }

        private void uniCompleted() {
            this.lock.lock();
            this.uniHasTerminated = true;
            this.lock.unlock();
            if (this.terminatedEarly) {
                this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                this.downstream.onSubscribe(Subscriptions.empty());
                if (this.failure != null) {
                    this.downstream.onFailure(this.failure);
                } else {
                    this.downstream.onComplete();
                }
            } else {
                this.downstream.onSubscribe(this);
            }
        }
    }
}

