/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

public class MultiConcatMapOp<I, O>
extends AbstractMultiOperator<I, O> {
    private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
    private final boolean postponeFailurePropagation;

    public MultiConcatMapOp(Multi<? extends I> upstream, Function<? super I, ? extends Flow.Publisher<? extends O>> mapper, boolean postponeFailurePropagation) {
        super(upstream);
        this.mapper = mapper;
        this.postponeFailurePropagation = postponeFailurePropagation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super O> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        ConcatMapSubscriber<? super I, ? super O> concatMapSubscriber = new ConcatMapSubscriber<I, O>(this.mapper, this.postponeFailurePropagation, subscriber);
        this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, concatMapSubscriber));
    }

    static class ConcatMapSubscriber<I, O>
    implements MultiSubscriber<I>,
    Flow.Subscription,
    ContextSupport {
        private final Function<? super I, ? extends Flow.Publisher<? extends O>> mapper;
        private final boolean postponeFailurePropagation;
        private final MultiSubscriber<? super O> downstream;
        private volatile long demand = 0L;
        private volatile State state = State.INIT;
        private volatile Flow.Subscription upstream;
        private Flow.Subscription currentUpstream;
        private boolean upstreamHasCompleted = false;
        private Throwable failure;
        private static final AtomicReferenceFieldUpdater<ConcatMapSubscriber, Flow.Subscription> UPSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcatMapSubscriber.class, Flow.Subscription.class, "upstream");
        private static final AtomicReferenceFieldUpdater<ConcatMapSubscriber, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcatMapSubscriber.class, State.class, "state");
        private static final AtomicLongFieldUpdater<ConcatMapSubscriber> DEMAND_UPDATER = AtomicLongFieldUpdater.newUpdater(ConcatMapSubscriber.class, "demand");
        private final MultiSubscriber<O> innerSubscriber = new InnerSubscriber();

        ConcatMapSubscriber(Function<? super I, ? extends Flow.Publisher<? extends O>> mapper, boolean postponeFailurePropagation, MultiSubscriber<? super O> downstream) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.postponeFailurePropagation = postponeFailurePropagation;
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (UPSTREAM_UPDATER.compareAndSet(this, null, subscription)) {
                this.downstream.onSubscribe(this);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(I item) {
            if (this.state == State.CANCELLED) {
                return;
            }
            if (STATE_UPDATER.compareAndSet(this, State.WAITING_NEXT_PUBLISHER, State.WAITING_NEXT_SUBSCRIPTION)) {
                try {
                    Flow.Publisher<O> publisher = this.mapper.apply(item);
                    if (publisher == null) {
                        throw new NullPointerException("The mapper produced a null publisher");
                    }
                    publisher.subscribe(this.innerSubscriber);
                }
                catch (Throwable err) {
                    this.upstream.cancel();
                    this.onFailure(err);
                }
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (STATE_UPDATER.getAndSet(this, State.CANCELLED) == State.CANCELLED) {
                return;
            }
            this.downstream.onFailure(this.addFailure(failure));
        }

        private Throwable addFailure(Throwable failure) {
            this.failure = this.failure != null ? (this.failure instanceof CompositeException ? new CompositeException((CompositeException)this.failure, failure) : new CompositeException(this.failure, failure)) : failure;
            return this.failure;
        }

        @Override
        public void onCompletion() {
            if (this.state == State.CANCELLED) {
                return;
            }
            this.upstreamHasCompleted = true;
            if (STATE_UPDATER.compareAndSet(this, State.WAITING_NEXT_PUBLISHER, State.CANCELLED) || STATE_UPDATER.compareAndSet(this, State.INIT, State.CANCELLED)) {
                if (this.failure == null) {
                    this.downstream.onCompletion();
                } else {
                    this.downstream.onFailure(this.failure);
                }
            }
        }

        @Override
        public void request(long n) {
            if (this.state == State.CANCELLED) {
                return;
            }
            if (n <= 0L) {
                this.cancel();
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            } else {
                Subscriptions.add(DEMAND_UPDATER, this, n);
                if (STATE_UPDATER.compareAndSet(this, State.INIT, State.WAITING_NEXT_PUBLISHER)) {
                    this.upstream.request(1L);
                } else if (this.state == State.WAITING_NEXT_PUBLISHER) {
                    this.upstream.request(1L);
                } else if (this.state == State.EMITTING) {
                    this.currentUpstream.request(n);
                }
            }
        }

        @Override
        public void cancel() {
            State previousState = STATE_UPDATER.getAndSet(this, State.CANCELLED);
            if (previousState == State.CANCELLED) {
                return;
            }
            if (previousState == State.EMITTING) {
                this.currentUpstream.cancel();
                this.upstream.cancel();
            } else if (this.upstream != null) {
                this.upstream.cancel();
            }
        }

        class InnerSubscriber
        implements MultiSubscriber<O>,
        ContextSupport {
            InnerSubscriber() {
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                if (ConcatMapSubscriber.this.state == State.CANCELLED) {
                    return;
                }
                ConcatMapSubscriber.this.currentUpstream = subscription;
                ConcatMapSubscriber.this.state = State.EMITTING;
                long pending = ConcatMapSubscriber.this.demand;
                if (pending > 0L) {
                    ConcatMapSubscriber.this.currentUpstream.request(pending);
                }
            }

            @Override
            public void onItem(O item) {
                if (ConcatMapSubscriber.this.state == State.CANCELLED) {
                    return;
                }
                DEMAND_UPDATER.decrementAndGet(ConcatMapSubscriber.this);
                ConcatMapSubscriber.this.downstream.onItem(item);
            }

            @Override
            public void onFailure(Throwable failure) {
                if (ConcatMapSubscriber.this.state == State.CANCELLED) {
                    return;
                }
                ConcatMapSubscriber.this.state = State.WAITING_NEXT_PUBLISHER;
                Throwable err = ConcatMapSubscriber.this.addFailure(failure);
                if (ConcatMapSubscriber.this.postponeFailurePropagation) {
                    this.onCompletion();
                } else {
                    ConcatMapSubscriber.this.state = State.CANCELLED;
                    ConcatMapSubscriber.this.upstream.cancel();
                    ConcatMapSubscriber.this.downstream.onFailure(err);
                }
            }

            @Override
            public void onCompletion() {
                if (ConcatMapSubscriber.this.state == State.CANCELLED) {
                    return;
                }
                if (!ConcatMapSubscriber.this.upstreamHasCompleted) {
                    ConcatMapSubscriber.this.state = State.WAITING_NEXT_PUBLISHER;
                    if (ConcatMapSubscriber.this.demand > 0L) {
                        ConcatMapSubscriber.this.upstream.request(1L);
                    }
                } else {
                    ConcatMapSubscriber.this.state = State.CANCELLED;
                    if (ConcatMapSubscriber.this.failure != null) {
                        ConcatMapSubscriber.this.downstream.onFailure(ConcatMapSubscriber.this.failure);
                    } else {
                        ConcatMapSubscriber.this.downstream.onComplete();
                    }
                }
            }

            @Override
            public Context context() {
                if (ConcatMapSubscriber.this.downstream instanceof ContextSupport) {
                    return ((ContextSupport)((Object)ConcatMapSubscriber.this.downstream)).context();
                }
                return Context.empty();
            }
        }

        private static enum State {
            INIT,
            WAITING_NEXT_PUBLISHER,
            WAITING_NEXT_SUBSCRIPTION,
            EMITTING,
            CANCELLED;

        }
    }
}

