/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Iterator;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

public class IterableBasedMulti<T>
extends AbstractMulti<T> {
    private final Iterable<? extends T> source;

    public IterableBasedMulti(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        Iterator<? extends T> iterator;
        ParameterValidation.nonNullNpe(downstream, "subscriber");
        try {
            iterator = this.source.iterator();
        }
        catch (Throwable e) {
            Subscriptions.fail(downstream, e);
            return;
        }
        IterableBasedMulti.subscribe(downstream, iterator);
    }

    public static <T> void subscribe(MultiSubscriber<? super T> downstream, Iterator<? extends T> iterator) {
        boolean hasNext;
        try {
            hasNext = iterator.hasNext();
        }
        catch (Throwable e) {
            Subscriptions.fail(downstream, e);
            return;
        }
        if (!hasNext) {
            Subscriptions.complete(downstream);
            return;
        }
        downstream.onSubscribe(new IteratorSubscription<T>(downstream, iterator));
    }

    private static final class IteratorSubscription<T>
    implements Flow.Subscription {
        private final Iterator<? extends T> iterator;
        private final MultiSubscriber<? super T> downstream;
        private volatile boolean cancelled;
        private final AtomicLong requested = new AtomicLong();

        IteratorSubscription(MultiSubscriber<? super T> downstream, Iterator<? extends T> iterator) {
            this.downstream = downstream;
            this.iterator = iterator;
        }

        @Override
        public final void request(long n) {
            if (n > 0L) {
                if (Subscriptions.add(this.requested, n) == 0L) {
                    if (n == Long.MAX_VALUE) {
                        this.fastPath();
                    } else {
                        this.slowPath(n);
                    }
                }
            } else {
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        private void fastPath() {
            boolean b;
            do {
                T t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = this.iterator.next();
                }
                catch (Throwable ex) {
                    this.downstream.onFailure(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t == null) {
                    this.downstream.onFailure(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                this.downstream.onItem(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = this.iterator.hasNext();
                }
                catch (Throwable ex) {
                    this.downstream.onFailure(ex);
                    return;
                }
            } while (b);
            if (!this.cancelled) {
                this.downstream.onCompletion();
            }
        }

        private void slowPath(long r) {
            long e = 0L;
            while (true) {
                if (e != r) {
                    boolean b;
                    T t;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t = this.iterator.next();
                    }
                    catch (Throwable ex) {
                        this.downstream.onFailure(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t == null) {
                        this.downstream.onFailure(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    this.downstream.onItem(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = this.iterator.hasNext();
                    }
                    catch (Throwable ex) {
                        this.downstream.onFailure(ex);
                        return;
                    }
                    if (!b) {
                        if (!this.cancelled) {
                            this.downstream.onCompletion();
                        }
                        return;
                    }
                    ++e;
                    continue;
                }
                r = this.requested.get();
                if (e != r) continue;
                r = this.requested.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }
}

