/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.BlockingIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.CancellableSubscriber;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.Subscribers;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MultiSubscribe<T> {
    private final AbstractMulti<T> upstream;

    public MultiSubscribe(AbstractMulti<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <S extends Flow.Subscriber<? super T>> S withSubscriber(S subscriber) {
        Flow.Subscriber<T> actual = Infrastructure.onMultiSubscription(this.upstream, subscriber);
        this.upstream.subscribe(actual);
        return subscriber;
    }

    public <S extends MultiSubscriber<? super T>> S withSubscriber(S subscriber) {
        this.upstream.subscribe(subscriber);
        return subscriber;
    }

    public Cancellable with(Consumer<? super Flow.Subscription> onSubscription, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onComplete) {
        return this.with(Context.empty(), onSubscription, onItem, onFailure, onComplete);
    }

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Cancellable with(Context context, Consumer<? super Flow.Subscription> onSubscription, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onComplete) {
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(context, "context"), ParameterValidation.nonNull(onItem, "onItem"), ParameterValidation.nonNull(onFailure, "onFailure"), ParameterValidation.nonNull(onComplete, "onComplete"), ParameterValidation.nonNull(onSubscription, "onSubscription"));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onComplete) {
        return this.with(Context.empty(), onItem, onFailure, onComplete);
    }

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Cancellable with(Context context, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onComplete) {
        ParameterValidation.nonNull(onItem, "onItem");
        ParameterValidation.nonNull(onFailure, "onFailure");
        ParameterValidation.nonNull(onComplete, "onComplete");
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(context, "context"), ParameterValidation.nonNull(onItem, "onItem"), ParameterValidation.nonNull(onFailure, "onFailure"), ParameterValidation.nonNull(onComplete, "onComplete"), s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem, Consumer<? super Throwable> onFailure) {
        return this.with(Context.empty(), onItem, onFailure);
    }

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Cancellable with(Context context, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure) {
        ParameterValidation.nonNull(onItem, "onItem");
        ParameterValidation.nonNull(onFailure, "onFailure");
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(context, "context"), ParameterValidation.nonNull(onItem, "onItem"), ParameterValidation.nonNull(onFailure, "onFailure"), null, s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem) {
        return this.with(Context.empty(), onItem);
    }

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Cancellable with(Context context, Consumer<? super T> onItem) {
        Consumer<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(onItem, "onItem"));
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(context, "context"), actual, Subscribers.NO_ON_FAILURE, null, s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    public Cancellable with(Consumer<? super T> onItem, Runnable onComplete) {
        return this.with(Context.empty(), onItem, onComplete);
    }

    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Cancellable with(Context context, Consumer<? super T> onItem, Runnable onComplete) {
        ParameterValidation.nonNull(onItem, "onItem");
        ParameterValidation.nonNull(onComplete, "onComplete");
        CancellableSubscriber<? super T> subscriber = Subscribers.from(ParameterValidation.nonNull(context, "context"), ParameterValidation.nonNull(onItem, "onItem"), null, onComplete, s -> s.request(Long.MAX_VALUE));
        return this.withSubscriber(subscriber);
    }

    @CheckReturnValue
    public BlockingIterable<T> asIterable() {
        return this.asIterable(256, () -> new ArrayBlockingQueue(256));
    }

    @CheckReturnValue
    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public BlockingIterable<T> asIterable(Supplier<Context> contextSupplier) {
        return this.asIterable(contextSupplier, 256, () -> new ArrayBlockingQueue(256));
    }

    @CheckReturnValue
    public BlockingIterable<T> asIterable(int batchSize, Supplier<Queue<T>> supplier) {
        return this.asIterable(Context::empty, batchSize, supplier);
    }

    @CheckReturnValue
    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public BlockingIterable<T> asIterable(Supplier<Context> contextSupplier, int batchSize, Supplier<Queue<T>> queueSupplier) {
        return new BlockingIterable<T>(this.upstream, batchSize, queueSupplier, contextSupplier);
    }

    @CheckReturnValue
    public Stream<T> asStream() {
        return this.asStream(256, () -> new ArrayBlockingQueue(256));
    }

    @CheckReturnValue
    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Stream<T> asStream(Supplier<Context> contextSupplier) {
        return this.asStream(contextSupplier, 256, () -> new ArrayBlockingQueue(256));
    }

    @CheckReturnValue
    public Stream<T> asStream(int batchSize, Supplier<Queue<T>> supplier) {
        return this.asIterable(batchSize, supplier).stream();
    }

    @CheckReturnValue
    @Experimental(value="Context support is a new experimental API introduced in Mutiny 1.3.0")
    public Stream<T> asStream(Supplier<Context> contextSupplier, int batchSize, Supplier<Queue<T>> queueSupplier) {
        return this.asIterable(contextSupplier, batchSize, queueSupplier).stream();
    }
}

