/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ExponentialBackoff;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiRetryOp;
import io.smallrye.mutiny.operators.multi.MultiRetryWhenOp;
import java.time.Duration;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;

public class MultiRetry<T> {
    private final Multi<T> upstream;
    private final Predicate<? super Throwable> onFailurePredicate;
    private Duration initialBackOff = Duration.ofSeconds(1L);
    private Duration maxBackoff = ExponentialBackoff.MAX_BACKOFF;
    private double jitter = 0.5;
    private boolean backOffConfigured = false;

    public MultiRetry(Multi<T> upstream, Predicate<? super Throwable> onFailurePredicate) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
        this.onFailurePredicate = ParameterValidation.nonNull(onFailurePredicate, "onFailurePredicate");
    }

    @CheckReturnValue
    public Multi<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    @CheckReturnValue
    public Multi<T> atMost(long numberOfAttempts) {
        ParameterValidation.positive(numberOfAttempts, "numberOfAttempts");
        if (this.backOffConfigured) {
            Function<Multi<Throwable>, Flow.Publisher<Long>> whenStreamFactory = ExponentialBackoff.randomExponentialBackoffFunction(numberOfAttempts, this.initialBackOff, this.maxBackoff, this.jitter, Infrastructure.getDefaultWorkerPool());
            return Infrastructure.onMultiCreation(new MultiRetryWhenOp<T>(this.upstream, this.onFailurePredicate, whenStreamFactory));
        }
        return Infrastructure.onMultiCreation(new MultiRetryOp<T>(this.upstream, this.onFailurePredicate, numberOfAttempts));
    }

    @CheckReturnValue
    public Multi<T> expireAt(long expireAt) {
        if (!this.backOffConfigured) {
            throw new IllegalArgumentException("Invalid retry configuration, `expiresAt/expiresIn` must be used with a back-off configuration");
        }
        Function<Multi<Throwable>, Flow.Publisher<Long>> whenStreamFactory = ExponentialBackoff.randomExponentialBackoffFunctionExpireAt(expireAt, this.initialBackOff, this.maxBackoff, this.jitter, Infrastructure.getDefaultWorkerPool());
        return Infrastructure.onMultiCreation(new MultiRetryWhenOp<T>(this.upstream, this.onFailurePredicate, whenStreamFactory));
    }

    @CheckReturnValue
    public Multi<T> expireIn(long expireIn) {
        return this.expireAt(System.currentTimeMillis() + expireIn);
    }

    @CheckReturnValue
    public Multi<T> until(Predicate<? super Throwable> predicate) {
        Predicate<? super Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        if (this.backOffConfigured) {
            throw new IllegalArgumentException("Invalid retry configuration, `until` cannot be used with a back-off configuration");
        }
        Function<Multi, Flow.Publisher> whenStreamFactory = stream -> stream.onItem().transformToUni(failure -> Uni.createFrom().emitter(emitter -> {
            try {
                if (actual.test((Throwable)failure)) {
                    emitter.complete(1L);
                } else {
                    emitter.fail((Throwable)failure);
                }
            }
            catch (Throwable ex) {
                emitter.fail(ex);
            }
        })).concatenate();
        return Infrastructure.onMultiCreation(new MultiRetryWhenOp<T>(this.upstream, this.onFailurePredicate, whenStreamFactory));
    }

    @CheckReturnValue
    public Multi<T> when(Function<Multi<Throwable>, ? extends Flow.Publisher<?>> whenStreamFactory) {
        if (this.backOffConfigured) {
            throw new IllegalArgumentException("Invalid retry configuration, `when` cannot be used with a back-off configuration");
        }
        Function<Multi<Throwable>, ? extends Flow.Publisher<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(whenStreamFactory, "whenStreamFactory"));
        return Infrastructure.onMultiCreation(new MultiRetryWhenOp<T>(this.upstream, this.onFailurePredicate, actual));
    }

    @CheckReturnValue
    public MultiRetry<T> withBackOff(Duration initialBackOff) {
        return this.withBackOff(initialBackOff, ExponentialBackoff.MAX_BACKOFF);
    }

    @CheckReturnValue
    public MultiRetry<T> withBackOff(Duration initialBackOff, Duration maxBackOff) {
        this.backOffConfigured = true;
        this.initialBackOff = ParameterValidation.validate(initialBackOff, "initialBackOff");
        this.maxBackoff = ParameterValidation.validate(maxBackOff, "maxBackOff");
        return this;
    }

    @CheckReturnValue
    public MultiRetry<T> withJitter(double jitter) {
        if (jitter < 0.0 || jitter > 1.0) {
            throw new IllegalArgumentException("Invalid `jitter`, the value must be in [0.0, 1.0]");
        }
        this.backOffConfigured = true;
        this.jitter = jitter;
        return this;
    }
}

