/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;

public class UniCallbackSubscriber<T>
implements UniSubscriber<T>,
UniSubscription {
    private volatile UniSubscription subscription;
    private static final AtomicReferenceFieldUpdater<UniCallbackSubscriber, UniSubscription> SUBSCRIPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(UniCallbackSubscriber.class, UniSubscription.class, "subscription");
    private final Consumer<? super T> onResultCallback;
    private final Consumer<? super Throwable> onFailureCallback;
    private final Context context;

    public UniCallbackSubscriber(Consumer<? super T> onResultCallback, Consumer<? super Throwable> onFailureCallback, Context context) {
        this.onResultCallback = ParameterValidation.nonNull(onResultCallback, "onResultCallback");
        this.onFailureCallback = ParameterValidation.nonNull(onFailureCallback, "onFailureCallback");
        this.context = ParameterValidation.nonNull(context, "context");
    }

    @Override
    public final void onSubscribe(UniSubscription sub) {
        if (!SUBSCRIPTION_UPDATER.compareAndSet(this, null, sub)) {
            sub.cancel();
        }
    }

    @Override
    public final void onFailure(Throwable t) {
        UniSubscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
        if (sub == EmptyUniSubscription.CANCELLED) {
            return;
        }
        this.onFailureCallback.accept(t);
    }

    @Override
    public final void onItem(T x) {
        Flow.Subscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
        if (sub == EmptyUniSubscription.CANCELLED) {
            return;
        }
        try {
            this.onResultCallback.accept(x);
        }
        catch (Throwable t) {
            Infrastructure.handleDroppedException(t);
        }
    }

    @Override
    public void cancel() {
        Flow.Subscription sub = SUBSCRIPTION_UPDATER.getAndSet(this, EmptyUniSubscription.CANCELLED);
        if (sub != null) {
            sub.cancel();
        }
    }

    @Override
    public Context context() {
        return this.context;
    }
}

