/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.unchecked;

import java.util.Objects;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface UncheckedBiConsumer<T, U> {
    public static <T, U> UncheckedBiConsumer<T, U> from(BiConsumer<T, U> consumer) {
        return consumer::accept;
    }

    public void accept(T var1, U var2) throws Exception;

    default public UncheckedBiConsumer<T, U> andThen(UncheckedBiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.accept(l, r);
            after.accept(l, r);
        };
    }

    default public BiConsumer<T, U> toBiConsumer() {
        return (x, y) -> {
            try {
                this.accept(x, y);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

