/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;

public abstract class MultiOperatorProcessor<I, O>
implements MultiSubscriber<I>,
Subscription {
    protected volatile MultiSubscriber<? super O> downstream;
    protected volatile Subscription upstream = null;
    private volatile int hasDownstreamCancelled = 0;
    private static final AtomicReferenceFieldUpdater<MultiOperatorProcessor, Subscription> UPSTREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MultiOperatorProcessor.class, Subscription.class, "upstream");
    private static final AtomicIntegerFieldUpdater<MultiOperatorProcessor> DOWNSTREAM_CANCELLED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MultiOperatorProcessor.class, "hasDownstreamCancelled");

    public MultiOperatorProcessor(MultiSubscriber<? super O> downstream) {
        this.downstream = ParameterValidation.nonNull(downstream, "downstream");
    }

    void failAndCancel(Throwable throwable) {
        Subscription subscription = this.getUpstreamSubscription();
        if (subscription != null) {
            subscription.cancel();
        }
        this.onFailure(throwable);
    }

    protected Subscription getUpstreamSubscription() {
        return this.upstream;
    }

    protected boolean compareAndSetUpstreamSubscription(Subscription expectedValue, Subscription newValue) {
        return UPSTREAM_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    protected Subscription getAndSetUpstreamSubscription(Subscription newValue) {
        return UPSTREAM_UPDATER.getAndSet(this, newValue);
    }

    protected boolean isDone() {
        return this.getUpstreamSubscription() == Subscriptions.CANCELLED;
    }

    protected boolean isCancelled() {
        return this.hasDownstreamCancelled == 1;
    }

    public void onSubscribe(Subscription subscription) {
        if (this.compareAndSetUpstreamSubscription(null, subscription)) {
            this.downstream.onSubscribe(this);
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onFailure(Throwable throwable) {
        Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onFailure(throwable);
        } else {
            Infrastructure.handleDroppedException(throwable);
        }
    }

    @Override
    public void onItem(I item) {
        Subscription subscription = this.getUpstreamSubscription();
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onItem(item);
        }
    }

    @Override
    public void onCompletion() {
        Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onCompletion();
        }
    }

    public void request(long numberOfItems) {
        Subscription subscription = this.getUpstreamSubscription();
        if (subscription != Subscriptions.CANCELLED) {
            if (numberOfItems <= 0L) {
                this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                return;
            }
            subscription.request(numberOfItems);
        }
    }

    public void cancel() {
        if (this.atomicallyFlipDownstreamHasCancelled()) {
            this.cancelUpstream();
            this.cleanup();
        }
    }

    protected final boolean atomicallyFlipDownstreamHasCancelled() {
        return DOWNSTREAM_CANCELLED_UPDATER.compareAndSet(this, 0, 1);
    }

    protected void cancelUpstream() {
        Subscription actual = UPSTREAM_UPDATER.getAndSet(this, Subscriptions.CANCELLED);
        if (actual != null && actual != Subscriptions.CANCELLED) {
            actual.cancel();
        }
    }

    protected void cleanup() {
        this.downstream = null;
    }
}

