/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.infrastructure;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MutinyScheduler
extends ScheduledThreadPoolExecutor {
    private final Executor executor;

    public MutinyScheduler(Executor executor) {
        super(1);
        this.executor = executor;
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new DecoratedRunnableTask<V>(task, this.executor);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new DecoratedRunnableTask<V>(task, this.executor);
    }

    static class DecoratedRunnableTask<V>
    implements RunnableScheduledFuture<V> {
        private final Executor executor;
        private final RunnableScheduledFuture<V> origin;

        public DecoratedRunnableTask(RunnableScheduledFuture<V> origin, Executor executor) {
            this.origin = origin;
            this.executor = executor;
        }

        @Override
        public boolean isPeriodic() {
            return this.origin.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.origin.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.origin.compareTo(o);
        }

        @Override
        public void run() {
            this.executor.execute(this.origin);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.origin.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.origin.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.origin.isDone();
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }
}

