/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnFailureRetry;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnFailureFlatMap;
import io.smallrye.mutiny.operators.UniOnFailureMap;
import io.smallrye.mutiny.operators.UniOnItemConsume;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class UniOnFailure<T> {
    private final Uni<T> upstream;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailure(Uni<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate == null ? x -> true : predicate;
    }

    public Uni<T> invoke(Consumer<Throwable> callback) {
        return Infrastructure.onUniCreation(new UniOnItemConsume<T>(this.upstream, null, ParameterValidation.nonNull(callback, "callback")));
    }

    public Uni<T> apply(Function<? super Throwable, ? extends Throwable> mapper) {
        return Infrastructure.onUniCreation(new UniOnFailureMap(this.upstream, this.predicate, mapper));
    }

    public Uni<T> recoverWithItem(T fallback) {
        return this.recoverWithItem(() -> fallback);
    }

    public Uni<T> recoverWithItem(Supplier<T> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.recoverWithItem((? super Throwable ignored) -> supplier.get());
    }

    public Uni<T> recoverWithItem(Function<? super Throwable, ? extends T> fallback) {
        ParameterValidation.nonNull(fallback, "fallback");
        return Infrastructure.onUniCreation(new UniOnFailureFlatMap<T>(this.upstream, this.predicate, failure -> {
            Object newResult = fallback.apply((Throwable)failure);
            return Uni.createFrom().item(newResult);
        }));
    }

    public Uni<T> recoverWithUni(Function<? super Throwable, ? extends Uni<? extends T>> fallback) {
        return Infrastructure.onUniCreation(new UniOnFailureFlatMap<T>(this.upstream, this.predicate, ParameterValidation.nonNull(fallback, "fallback")));
    }

    public Uni<T> recoverWithUni(Supplier<? extends Uni<? extends T>> supplier) {
        return this.recoverWithUni((? super Throwable ignored) -> (Uni)supplier.get());
    }

    public Uni<T> recoverWithUni(Uni<? extends T> fallback) {
        return this.recoverWithUni(() -> fallback);
    }

    public UniOnFailureRetry<T> retry() {
        return new UniOnFailureRetry<T>(this.upstream, this.predicate);
    }
}

