/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import java.util.function.Consumer;

public class UniOnEventConsume<T>
extends UniOperator<T, T> {
    private final Consumer<? super T> onResult;
    private final Consumer<Throwable> onFailure;

    public UniOnEventConsume(Uni<? extends T> upstream, Consumer<? super T> onResult, Consumer<Throwable> onFailure) {
        super(upstream);
        this.onResult = onResult;
        this.onFailure = onFailure;
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super T> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onItem(T item) {
                if (UniOnEventConsume.this.invokeEventHandler(UniOnEventConsume.this.onResult, item, false, subscriber)) {
                    subscriber.onItem(item);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (UniOnEventConsume.this.invokeEventHandler(UniOnEventConsume.this.onFailure, failure, true, subscriber)) {
                    subscriber.onFailure(failure);
                }
            }
        });
    }

    private <E> boolean invokeEventHandler(Consumer<? super E> handler, E event, boolean wasCalledByOnFailure, UniSerializedSubscriber<? super T> subscriber) {
        if (handler != null) {
            try {
                handler.accept(event);
            }
            catch (Throwable e) {
                if (wasCalledByOnFailure) {
                    subscriber.onFailure(new CompositeException((Throwable)event, e));
                } else {
                    subscriber.onFailure(e);
                }
                return false;
            }
        }
        return true;
    }
}

