/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.builders.SerializedMultiEmitter;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

abstract class BaseMultiEmitter<T>
implements MultiEmitter<T>,
Subscription {
    protected final AtomicLong requested = new AtomicLong();
    protected final MultiSubscriber<? super T> downstream;
    private final AtomicReference<Runnable> onTermination;
    private static final Runnable CLEARED = () -> {};

    BaseMultiEmitter(MultiSubscriber<? super T> downstream) {
        this.downstream = downstream;
        this.onTermination = new AtomicReference();
    }

    @Override
    public void complete() {
        this.completion();
    }

    protected void completion() {
        if (this.isCancelled()) {
            return;
        }
        try {
            this.downstream.onCompletion();
        }
        finally {
            this.cleanup();
        }
    }

    protected boolean isCancelled() {
        return this.onTermination.get() == CLEARED;
    }

    private void cleanup() {
        Runnable action = this.onTermination.getAndSet(CLEARED);
        if (action != null && action != CLEARED) {
            action.run();
        }
    }

    @Override
    public final void fail(Throwable failure) {
        this.failed(failure);
    }

    protected void failed(Throwable e) {
        if (e == null) {
            e = new NullPointerException("onError called with null.");
        }
        if (this.isCancelled()) {
            return;
        }
        try {
            this.downstream.onFailure(e);
        }
        finally {
            this.cleanup();
        }
    }

    public final void cancel() {
        this.cleanup();
        this.onUnsubscribed();
    }

    void onUnsubscribed() {
    }

    public final void request(long n) {
        if (n > 0L) {
            Subscriptions.add(this.requested, n);
            this.onRequested();
        }
    }

    void onRequested() {
    }

    @Override
    public MultiEmitter<T> onTermination(Runnable onTermination) {
        Runnable runnable = this.onTermination.getAndSet(onTermination);
        if (runnable != null) {
            runnable.run();
        }
        return this;
    }

    public MultiEmitter<T> serialize() {
        return new SerializedMultiEmitter(this);
    }
}

