/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class UniCreateFromPublisher<O>
extends UniOperator<Void, O> {
    private final Publisher<? extends O> publisher;

    public UniCreateFromPublisher(Publisher<? extends O> publisher) {
        super(null);
        this.publisher = ParameterValidation.nonNull(publisher, "publisher");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super O> subscriber) {
        final AtomicReference reference = new AtomicReference();
        Subscriber actual = new Subscriber<O>(){

            public void onSubscribe(Subscription s) {
                if (reference.compareAndSet(null, s)) {
                    subscriber.onSubscribe(() -> {
                        Subscription old = reference.getAndSet(EmptyUniSubscription.CANCELLED);
                        if (old != null) {
                            old.cancel();
                        }
                    });
                    s.request(1L);
                } else {
                    s.cancel();
                }
            }

            public void onNext(O o) {
                Subscription sub = reference.getAndSet(EmptyUniSubscription.CANCELLED);
                if (sub == EmptyUniSubscription.CANCELLED) {
                    return;
                }
                sub.cancel();
                subscriber.onItem(o);
            }

            public void onError(Throwable t) {
                subscriber.onFailure(t);
            }

            public void onComplete() {
                subscriber.onItem(null);
            }
        };
        Subscriber<? extends O> sub = Infrastructure.onMultiSubscription(this.publisher, actual);
        this.publisher.subscribe(sub);
    }
}

