/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiCollector;
import java.time.Duration;
import java.util.List;

public class MultiGroupIntoLists<T> {
    private final Multi<T> upstream;

    public MultiGroupIntoLists(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<List<T>> every(Duration duration) {
        return Infrastructure.onMultiCreation(MultiCollector.list(this.upstream, ParameterValidation.validate(duration, "duration")));
    }

    public Multi<List<T>> of(int size) {
        return Infrastructure.onMultiCreation(MultiCollector.list(this.upstream, ParameterValidation.positive(size, "size")));
    }

    public Multi<List<T>> of(int size, int skip) {
        return Infrastructure.onMultiCreation(MultiCollector.list(this.upstream, ParameterValidation.positive(size, "size"), ParameterValidation.positive(skip, "skip")));
    }

    public Multi<List<T>> of(int size, Duration maximumDelay) {
        return this.upstream.groupItems().intoMultis().every(maximumDelay).flatMap(withTimeout -> withTimeout.groupItems().intoLists().of(size));
    }
}

