/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiOverflowStrategy;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiOverflow<T> {
    private final Multi<T> upstream;

    public MultiOverflow(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> buffer() {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).buffer();
    }

    public Multi<T> buffer(int size) {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).buffer(size);
    }

    public Multi<T> drop() {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).drop();
    }

    @Deprecated
    public Multi<T> drop(Consumer<T> callback) {
        return new MultiOverflowStrategy<T>(this.upstream, ParameterValidation.nonNull(callback, "callback"), null).drop();
    }

    public Multi<T> dropPreviousItems() {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).dropPreviousItems();
    }

    public MultiOverflowStrategy<T> invoke(Consumer<T> consumer) {
        return new MultiOverflowStrategy<T>(this.upstream, ParameterValidation.nonNull(consumer, "consumer"), null);
    }

    public MultiOverflowStrategy<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((T ignored) -> actual.run());
    }

    public MultiOverflowStrategy<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.call((T ignored) -> (Uni)actual.get());
    }

    public MultiOverflowStrategy<T> call(Function<T, Uni<?>> mapper) {
        return new MultiOverflowStrategy<T>(this.upstream, null, ParameterValidation.nonNull(mapper, "mapper"));
    }
}

