/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class MultiFilterOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiFilterOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        if (downstream == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        this.upstream.subscribe().withSubscriber(new MultiFilterProcessor<T>(downstream, this.predicate));
    }

    static final class MultiFilterProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;
        private volatile boolean requestedMax = false;

        MultiFilterProcessor(MultiSubscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        @Override
        public void onItem(T t) {
            boolean passed;
            if (this.isDone()) {
                return;
            }
            try {
                passed = this.predicate.test(t);
            }
            catch (Throwable exception) {
                this.failAndCancel(exception);
                return;
            }
            if (passed) {
                this.downstream.onItem(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void request(long numberOfItems) {
            if (this.requestedMax) {
                return;
            }
            Subscription subscription = (Subscription)this.upstream.get();
            if (subscription != Subscriptions.CANCELLED) {
                if (numberOfItems <= 0L) {
                    this.onFailure(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
                }
                if (numberOfItems == Long.MAX_VALUE) {
                    this.requestedMax = true;
                }
                subscription.request(numberOfItems);
            }
        }
    }
}

