/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.overflow;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;

public class MultiOnOverflowDropItemsOp<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<? super T> onItemDrop;

    public MultiOnOverflowDropItemsOp(Multi<T> upstream) {
        super(upstream);
        this.onItemDrop = null;
    }

    public MultiOnOverflowDropItemsOp(Multi<T> upstream, Consumer<? super T> onItemDrop) {
        super(upstream);
        this.onItemDrop = onItemDrop;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe(new MultiOnOverflowDropItemsProcessor<T>(downstream, this.onItemDrop));
    }

    static final class MultiOnOverflowDropItemsProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Consumer<? super T> onItemDrop;
        private final AtomicLong requested = new AtomicLong();

        MultiOnOverflowDropItemsProcessor(MultiSubscriber<? super T> downstream, Consumer<? super T> onItemDrop) {
            super(downstream);
            this.onItemDrop = onItemDrop;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            if (this.isDone()) {
                return;
            }
            long req = this.requested.get();
            if (req != 0L) {
                this.downstream.onItem(item);
                Subscriptions.subtract(this.requested, 1L);
            } else {
                this.drop(item);
            }
        }

        private void drop(T item) {
            if (this.onItemDrop != null) {
                try {
                    this.onItemDrop.accept(item);
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
            }
        }
    }
}

