/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import io.smallrye.mutiny.operators.multi.multicast.MultiReferenceCount;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiReferenceCountSubscriber<T>
extends MultiOperatorProcessor<T, T> {
    private final AtomicBoolean done = new AtomicBoolean();
    private final MultiReferenceCount<T> parent;
    private final ConnectableMultiConnection connection;

    MultiReferenceCountSubscriber(MultiSubscriber<? super T> downstream, MultiReferenceCount<T> parent, ConnectableMultiConnection connection) {
        super(downstream);
        this.parent = parent;
        this.connection = connection;
    }

    @Override
    public void onItem(T t) {
        this.downstream.onItem(t);
    }

    @Override
    public void onFailure(Throwable failure) {
        if (this.done.compareAndSet(false, true)) {
            this.parent.terminated(this.connection);
            super.onFailure(failure);
        }
    }

    @Override
    public void onCompletion() {
        if (this.done.compareAndSet(false, true)) {
            this.parent.terminated(this.connection);
            super.onCompletion();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.done.compareAndSet(false, true)) {
            this.parent.cancel(this.connection);
        }
    }
}

