/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import io.smallrye.mutiny.operators.multi.multicast.MultiConnectAfter;
import io.smallrye.mutiny.operators.multi.multicast.MultiReferenceCount;
import java.time.Duration;

public abstract class ConnectableMulti<T>
extends AbstractMulti<T> {
    protected final Multi<T> upstream;

    protected ConnectableMulti(Multi<T> upstream) {
        this.upstream = upstream;
    }

    protected abstract void connect(ConnectableMultiConnection var1);

    public Multi<T> referenceCount() {
        return new MultiReferenceCount(this);
    }

    public Multi<T> referenceCount(int count, Duration duration) {
        if (duration != null) {
            ParameterValidation.validate(duration, "duration");
        }
        ParameterValidation.positive(count, "count");
        return new MultiReferenceCount(this, count, duration);
    }

    public Multi<T> connectAfter(int numberOfSubscribers) {
        ParameterValidation.positive(numberOfSubscribers, "numberOfSubscribers");
        return new MultiConnectAfter(this, numberOfSubscribers, null);
    }
}

