/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiSkipUntilPublisherOp<T, U>
extends AbstractMultiOperator<T, T> {
    private final Publisher<U> other;

    public MultiSkipUntilPublisherOp(Multi<? extends T> upstream, Publisher<U> other) {
        super(upstream);
        this.other = ParameterValidation.nonNull(other, "other");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        SkipUntilMainProcessor<? super T> main = new SkipUntilMainProcessor<T>(actual);
        OtherStreamTracker otherSubscriber = new OtherStreamTracker(main);
        this.other.subscribe(otherSubscriber);
        this.upstream.subscribe(main);
    }

    static final class SkipUntilMainProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private AtomicReference<Subscription> other = new AtomicReference();
        private AtomicBoolean gate = new AtomicBoolean(false);

        SkipUntilMainProcessor(Subscriber<? super T> downstream) {
            super(new SerializedSubscriber<T>(downstream));
        }

        void open() {
            if (this.gate.compareAndSet(false, true)) {
                Subscriptions.cancel(this.other);
            }
        }

        boolean isOpened() {
            return this.gate.get();
        }

        void setOtherSubscription(Subscription s) {
            if (this.other.compareAndSet(null, s)) {
                s.request(1L);
            } else {
                s.cancel();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            Subscriptions.cancel(this.other);
        }

        @Override
        public void onItem(T t) {
            if (this.gate.get()) {
                this.downstream.onItem(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            Subscriptions.cancel(this.other);
            super.onFailure(t);
        }

        @Override
        public void onCompletion() {
            Subscriptions.cancel(this.other);
            super.onCompletion();
        }
    }

    static final class OtherStreamTracker<U>
    implements MultiSubscriber<U> {
        private final SkipUntilMainProcessor<?> main;

        OtherStreamTracker(SkipUntilMainProcessor<?> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOtherSubscription(s);
        }

        @Override
        public void onItem(U t) {
            this.main.open();
        }

        @Override
        public void onFailure(Throwable t) {
            if (!this.main.isOpened()) {
                this.main.onFailure(t);
            }
        }

        @Override
        public void onCompletion() {
            this.main.open();
        }
    }
}

