/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class UniSubscribeToCompletionStage {
    public static <T> CompletableFuture<T> subscribe(Uni<T> uni) {
        final AtomicReference ref = new AtomicReference();
        final CompletableFuture future = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                UniSubscription s;
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                if (cancelled && (s = ref.getAndSet(EmptyUniSubscription.CANCELLED)) != null) {
                    s.cancel();
                }
                return cancelled;
            }
        };
        uni.subscribe().withSubscriber(new UniSubscriber<T>(){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                if (!ref.compareAndSet(null, subscription)) {
                    future.completeExceptionally(new IllegalStateException("Invalid subscription state - Already having an upstream subscription"));
                }
            }

            @Override
            public void onItem(T item) {
                if (ref.getAndSet(EmptyUniSubscription.CANCELLED) != EmptyUniSubscription.CANCELLED) {
                    future.complete(item);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (ref.getAndSet(EmptyUniSubscription.CANCELLED) != EmptyUniSubscription.CANCELLED) {
                    future.completeExceptionally(failure);
                }
            }
        });
        return future;
    }
}

