/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.GroupedMulti;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiBufferOp;
import io.smallrye.mutiny.operators.multi.MultiBufferWithTimeoutOp;
import io.smallrye.mutiny.operators.multi.MultiCollectorOp;
import io.smallrye.mutiny.operators.multi.MultiGroupByOp;
import io.smallrye.mutiny.operators.multi.MultiLastItemOp;
import io.smallrye.mutiny.operators.multi.MultiWindowOnDurationOp;
import io.smallrye.mutiny.operators.multi.MultiWindowOp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class MultiCollector {
    private MultiCollector() {
    }

    public static <T> Uni<T> first(Multi<T> upstream) {
        return Uni.createFrom().multi(upstream);
    }

    public static <T> Uni<T> last(Multi<T> upstream) {
        return Uni.createFrom().publisher(new MultiLastItemOp<T>(upstream));
    }

    public static <T> Uni<List<T>> list(Multi<T> upstream) {
        return MultiCollector.collector(upstream, Collectors.toList(), false);
    }

    public static <T, A, R> Uni<R> collector(Multi<T> upstream, Collector<? super T, A, ? extends R> collector, boolean acceptNullAsInitialValue) {
        MultiCollectorOp<? super T, A, ? extends R> f = new MultiCollectorOp<T, A, R>(upstream, collector, acceptNullAsInitialValue);
        return Uni.createFrom().publisher(f);
    }

    public static <R, T> Uni<R> collectInto(Multi<T> upstream, Supplier<R> producer, BiConsumer<R, ? super T> combinator) {
        Collector<? super T, R, R> collector = Collector.of(producer, combinator, (r, r2) -> r, Collector.Characteristics.IDENTITY_FINISH);
        return MultiCollector.collector(upstream, collector, false);
    }

    public static <K, T> Uni<Map<K, T>> map(Multi<T> upstream, Function<? super T, ? extends K> keyMapper) {
        return MultiCollector.map(upstream, keyMapper, Function.identity());
    }

    public static <K, V, T> Uni<Map<K, V>> map(Multi<T> upstream, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MultiCollector.collector(upstream, Collectors.toMap(keyMapper, valueMapper), false);
    }

    public static <K, V, R> Uni<Map<K, Collection<V>>> multimap(Multi<R> upstream, Function<? super R, ? extends K> keyMapper, Function<? super R, ? extends V> valueMapper) {
        return MultiCollector.collector(upstream, Collectors.toMap(keyMapper, res -> {
            ArrayList list = new ArrayList();
            Object mapped = valueMapper.apply((Object)res);
            list.add(mapped);
            return list;
        }, (vs, vs2) -> {
            vs.addAll(vs2);
            return vs;
        }), false);
    }

    public static <T> Multi<List<T>> list(Multi<T> upstream, Duration timeWindow) {
        return new MultiBufferWithTimeoutOp<T>(upstream, Integer.MAX_VALUE, timeWindow, Infrastructure.getDefaultWorkerPool());
    }

    public static <T> Multi<List<T>> list(Multi<T> upstream, int size) {
        return new MultiBufferOp<T>(upstream, size, size);
    }

    public static <T> Multi<List<T>> list(Multi<T> upstream, int size, int skip) {
        return new MultiBufferOp<T>(upstream, size, skip);
    }

    public static <T> Multi<Multi<T>> multi(Multi<T> upstream, Duration timeWindow) {
        return new MultiWindowOnDurationOp<T>(upstream, timeWindow, Infrastructure.getDefaultWorkerPool());
    }

    public static <T> Multi<Multi<T>> multi(Multi<T> upstream, int size) {
        return new MultiWindowOp<T>(upstream, size, size);
    }

    public static <T> Multi<Multi<T>> multi(Multi<T> upstream, int size, int skip) {
        return new MultiWindowOp<T>(upstream, size, skip);
    }

    public static <K, V, T> Multi<GroupedMulti<K, V>> groupBy(Multi<T> upstream, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        if (valueMapper == null) {
            return new MultiGroupByOp<Object, K, Object>(upstream, keyMapper, x -> x);
        }
        return new MultiGroupByOp<T, K, V>(upstream, keyMapper, valueMapper);
    }
}

