/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.multicast.MultiPublishOp;
import java.time.Duration;

public class MultiBroadcaster {
    public static <T> Multi<T> publish(Multi<T> upstream, int numberOfSubscribers, boolean cancelWhenNoOneIsListening, Duration delayAfterLastDeparture) {
        if (numberOfSubscribers > 0) {
            return MultiBroadcaster.createPublishWithSubscribersThreshold(upstream, numberOfSubscribers, cancelWhenNoOneIsListening, delayAfterLastDeparture);
        }
        return MultiBroadcaster.createPublishImmediate(upstream, cancelWhenNoOneIsListening, delayAfterLastDeparture);
    }

    private static <T> Multi<T> createPublishImmediate(Multi<T> upstream, boolean cancelWhenNoOneIsListening, Duration delayAfterLastDeparture) {
        if (cancelWhenNoOneIsListening) {
            if (delayAfterLastDeparture != null) {
                return MultiPublishOp.create(upstream).referenceCount(1, delayAfterLastDeparture);
            }
            return MultiPublishOp.create(upstream).referenceCount();
        }
        return MultiPublishOp.create(upstream).connectAfter(1);
    }

    private static <T> Multi<T> createPublishWithSubscribersThreshold(Multi<T> upstream, int numberOfSubscribers, boolean cancelWhenNoOneIsListening, Duration delayAfterLastDeparture) {
        if (cancelWhenNoOneIsListening) {
            if (delayAfterLastDeparture != null) {
                return MultiPublishOp.create(upstream).referenceCount(numberOfSubscribers, delayAfterLastDeparture);
            }
            return MultiPublishOp.create(upstream).referenceCount(numberOfSubscribers, null);
        }
        return MultiPublishOp.create(upstream).connectAfter(numberOfSubscribers);
    }

    private MultiBroadcaster() {
    }
}

