/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.builders.IntervalMulti;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;

public class MultiTimePeriod {
    private Duration initialDelay;
    private ScheduledExecutorService executor = Infrastructure.getDefaultWorkerPool();

    public MultiTimePeriod startingAfter(Duration duration) {
        this.initialDelay = ParameterValidation.validate(duration, "duration");
        return this;
    }

    public MultiTimePeriod onExecutor(ScheduledExecutorService executor) {
        this.executor = ParameterValidation.nonNull(executor, "executor");
        return this;
    }

    public Multi<Long> every(Duration duration) {
        ParameterValidation.validate(duration, "duration");
        if (this.initialDelay != null) {
            return new IntervalMulti(this.initialDelay, duration, this.executor);
        }
        return new IntervalMulti(duration, this.executor);
    }
}

