/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.overflow;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.SpscArrayQueue;
import io.smallrye.mutiny.helpers.queues.SpscLinkedArrayQueue;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiOnOverflowBufferOp<T>
extends AbstractMultiOperator<T, T> {
    private final int bufferSize;
    private final boolean unbounded;
    private final boolean postponeFailurePropagation;
    private final Consumer<T> onOverflow;

    public MultiOnOverflowBufferOp(Multi<T> upstream, int bufferSize, boolean unbounded, boolean postponeFailurePropagation, Consumer<T> onOverflow) {
        super(upstream);
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.postponeFailurePropagation = postponeFailurePropagation;
        this.onOverflow = onOverflow;
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        OnOverflowBufferProcessor<? super T> subscriber = new OnOverflowBufferProcessor<T>(downstream, this.bufferSize, this.unbounded, this.postponeFailurePropagation, this.onOverflow);
        this.upstream.subscribe(subscriber);
    }

    static final class OnOverflowBufferProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Queue<T> queue;
        private final boolean postponeFailurePropagation;
        private final Consumer<T> onOverflow;
        Throwable failure;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger wip = new AtomicInteger();
        volatile boolean cancelled;
        volatile boolean done;

        OnOverflowBufferProcessor(Subscriber<? super T> downstream, int bufferSize, boolean unbounded, boolean postponeFailurePropagation, Consumer<T> onOverflow) {
            super(downstream);
            this.onOverflow = onOverflow;
            this.postponeFailurePropagation = postponeFailurePropagation;
            this.queue = unbounded ? new SpscLinkedArrayQueue(bufferSize) : new SpscArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                BackPressureFailure ex = new BackPressureFailure("Buffer is full due to lack of downstream consumption");
                try {
                    this.onOverflow.accept(t);
                }
                catch (Throwable e) {
                    ex.initCause(e);
                }
                this.onError(ex);
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable failure) {
            this.failure = failure;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                super.cancel();
                if (this.wip.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            block5: {
                if (this.wip.getAndIncrement() != 0) break block5;
                int missed = 1;
                Queue<T> qe = this.queue;
                do {
                    boolean empty;
                    boolean d;
                    long emitted;
                    if (this.checkTerminated(this.done, qe.isEmpty())) {
                        return;
                    }
                    long req = this.requested.get();
                    for (emitted = 0L; emitted != req; ++emitted) {
                        boolean wasEmpty;
                        boolean wasDone = this.done;
                        T item = qe.poll();
                        boolean bl = wasEmpty = item == null;
                        if (this.checkTerminated(wasDone, wasEmpty)) {
                            return;
                        }
                        if (wasEmpty) break;
                        this.downstream.onNext(item);
                    }
                    if (emitted == req && this.checkTerminated(d = this.done, empty = qe.isEmpty())) {
                        return;
                    }
                    if (emitted == 0L || req == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-emitted);
                } while ((missed = this.wip.addAndGet(-missed)) != 0);
            }
        }

        boolean checkTerminated(boolean wasDone, boolean wasEmpty) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (wasDone) {
                if (this.postponeFailurePropagation) {
                    if (wasEmpty) {
                        if (this.failure != null) {
                            super.onError(this.failure);
                        } else {
                            super.onComplete();
                        }
                        return true;
                    }
                } else {
                    if (this.failure != null) {
                        this.queue.clear();
                        super.onError(this.failure);
                        return true;
                    }
                    if (wasEmpty) {
                        super.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

