/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMulti;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MultiConnectAfter<T>
extends MultiOperator<T, T> {
    private final int numberOfSubscribers;
    private final AtomicInteger count = new AtomicInteger();
    private final ConnectableMultiConnection connection;

    public MultiConnectAfter(ConnectableMulti<T> upstream, int numberOfSubscribers, ConnectableMultiConnection connection) {
        super(upstream);
        this.numberOfSubscribers = numberOfSubscribers;
        this.connection = connection;
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        this.upstream().subscribe(downstream);
        if (this.count.incrementAndGet() == this.numberOfSubscribers) {
            ((ConnectableMulti)this.upstream()).connect(this.connection);
        }
    }
}

