/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;

public final class MultiTakeWhileOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiTakeWhileOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        ParameterValidation.nonNullNpe(actual, "subscriber");
        this.upstream.subscribe(new TakeWhileProcessor<T>(actual, this.predicate));
    }

    static final class TakeWhileProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;

        TakeWhileProcessor(Subscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        public void onNext(T t) {
            boolean pass;
            if (this.isDone()) {
                return;
            }
            try {
                pass = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (!pass) {
                this.cancel();
                this.downstream.onComplete();
                return;
            }
            this.downstream.onNext(t);
        }
    }
}

