/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiTakeOp<T>
extends AbstractMultiOperator<T, T> {
    private final long numberOfItems;

    public MultiTakeOp(Multi<? extends T> upstream, long numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        ParameterValidation.nonNullNpe(downstream, "subscriber");
        this.upstream.subscribe(new TakeProcessor<T>(downstream, this.numberOfItems));
    }

    static final class TakeProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final long numberOfItems;
        private long remaining;
        private AtomicInteger wip = new AtomicInteger();

        TakeProcessor(Subscriber<? super T> downstream, long numberOfItems) {
            super(downstream);
            this.numberOfItems = numberOfItems;
            this.remaining = numberOfItems;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.upstream.compareAndSet(null, s)) {
                if (this.numberOfItems == 0L) {
                    ((Subscription)this.upstream.getAndSet(Subscriptions.CANCELLED)).cancel();
                    Subscriptions.complete(this.downstream);
                } else {
                    this.downstream.onSubscribe((Subscription)this);
                }
            } else {
                s.cancel();
            }
        }

        public void onNext(T t) {
            if (this.upstream.get() == Subscriptions.CANCELLED) {
                return;
            }
            long r = this.remaining;
            if (r == 0L) {
                ((Subscription)this.upstream.getAndSet(Subscriptions.CANCELLED)).cancel();
                this.downstream.onComplete();
                return;
            }
            this.remaining = --r;
            this.downstream.onNext(t);
            if (r == 0L) {
                ((Subscription)this.upstream.getAndSet(Subscriptions.CANCELLED)).cancel();
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError((Throwable)Subscriptions.getInvalidRequestException());
                return;
            }
            Subscription actual = (Subscription)this.upstream.get();
            if (this.wip.compareAndSet(0, 1)) {
                if (n >= this.numberOfItems) {
                    actual.request(Long.MAX_VALUE);
                } else {
                    actual.request(n);
                }
                return;
            }
            actual.request(n);
        }
    }
}

