/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.ArrayDeque;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiSkipLastOp<T>
extends AbstractMultiOperator<T, T> {
    private final int numberOfItems;

    public MultiSkipLastOp(Multi<? extends T> upstream, int numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        if (this.numberOfItems == 0) {
            this.upstream.subscribe(actual);
        } else {
            this.upstream.subscribe(new SkipLastProcessor<T>(actual, this.numberOfItems));
        }
    }

    static final class SkipLastProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final int numberOfItems;
        private final ArrayDeque<T> queue = new ArrayDeque();

        SkipLastProcessor(Subscriber<? super T> actual, int numberOfItems) {
            super(actual);
            this.numberOfItems = numberOfItems;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request((long)this.numberOfItems);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T t) {
            if (this.queue.size() == this.numberOfItems) {
                this.downstream.onNext(this.queue.pollFirst());
            }
            this.queue.offerLast(t);
        }

        @Override
        public void onError(Throwable t) {
            this.queue.clear();
            super.onError(t);
        }

        @Override
        public void onComplete() {
            this.queue.clear();
            super.onComplete();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.queue.clear();
        }
    }
}

