/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiLastItemOp<T>
extends AbstractMultiOperator<T, T> {
    public MultiLastItemOp(Multi<T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        this.upstream.subscribe(new MultiLastItemProcessor<T>(downstream));
    }

    static final class MultiLastItemProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        T last;

        MultiLastItemProcessor(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T item) {
            this.last = item;
        }

        @Override
        public void onError(Throwable failure) {
            super.onError(failure);
            this.last = null;
        }

        @Override
        public void onComplete() {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                T item = this.last;
                if (item != null) {
                    this.last = null;
                    this.downstream.onNext(item);
                    this.downstream.onComplete();
                } else {
                    this.downstream.onComplete();
                }
            }
        }
    }
}

