/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

public final class MultiDistinctOp<T>
extends AbstractMultiOperator<T, T> {
    public MultiDistinctOp(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("Subscriber cannot be `null`");
        }
        this.upstream.subscribe(new DistinctProcessor<T>(actual));
    }

    static final class DistinctProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        final Collection<T> collection;
        final AtomicLong requested = new AtomicLong();

        DistinctProcessor(Subscriber<? super T> downstream) {
            super(downstream);
            this.collection = new HashSet<T>();
        }

        public void onNext(T t) {
            if (this.isDone()) {
                return;
            }
            if (this.collection.add(t)) {
                this.downstream.onNext(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onError(Throwable t) {
            super.onError(t);
            this.collection.clear();
        }

        @Override
        public void onComplete() {
            super.onComplete();
            this.collection.clear();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.collection.clear();
        }
    }
}

