/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MultiConcatOp<T>
extends AbstractMulti<T> {
    private final Publisher<? extends T>[] publishers;
    private final boolean postponeFailurePropagation;

    @SafeVarargs
    public MultiConcatOp(boolean postponeFailurePropagation, Publisher<? extends T> ... publishers) {
        this.publishers = ParameterValidation.doesNotContainNull(publishers, "publishers");
        this.postponeFailurePropagation = postponeFailurePropagation;
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        if (this.publishers.length == 0) {
            Subscriptions.complete(actual);
            return;
        }
        if (this.publishers.length == 1) {
            this.publishers[0].subscribe(actual);
            return;
        }
        if (this.postponeFailurePropagation) {
            ConcatArrayAndPostponeFailureSubscriber<T> parent = new ConcatArrayAndPostponeFailureSubscriber<T>(actual, this.publishers);
            actual.onSubscribe(parent);
            if (!parent.isCancelled()) {
                parent.onComplete();
            }
        } else {
            ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(actual, this.publishers);
            actual.onSubscribe(parent);
            if (!parent.isCancelled()) {
                parent.onComplete();
            }
        }
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }

    static final class ConcatArrayAndPostponeFailureSubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        final Publisher<? extends T>[] upstreams;
        int index;
        long produced;
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicReference<Throwable> failure = new AtomicReference();

        ConcatArrayAndPostponeFailureSubscriber(Subscriber<? super T> actual, Publisher<? extends T>[] upstreams) {
            super(actual);
            this.upstreams = upstreams;
        }

        public void onNext(T t) {
            ++this.produced;
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (Subscriptions.addFailure(this.failure, t)) {
                this.onComplete();
            }
        }

        @Override
        public void onComplete() {
            if (this.wip.getAndIncrement() == 0) {
                Publisher<? extends T>[] a = this.upstreams;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.index;
                    if (i == a.length) {
                        Throwable last = Subscriptions.markFailureAsTerminated(this.failure);
                        if (last != null) {
                            this.downstream.onError(last);
                        } else {
                            this.downstream.onComplete();
                        }
                        return;
                    }
                    Publisher<? extends T> p = a[i];
                    if (p == null) {
                        this.downstream.onError((Throwable)new NullPointerException("Source Publisher at currentIndex " + i + " is null"));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.emitted(c);
                    }
                    p.subscribe((Subscriber)this);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.index = ++i;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class ConcatArraySubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Publisher<? extends T>[] upstreams;
        private int currentIndex;
        private long emitted;
        private final AtomicInteger wip = new AtomicInteger();

        ConcatArraySubscriber(Subscriber<? super T> actual, Publisher<? extends T>[] upstreams) {
            super(actual);
            this.upstreams = upstreams;
        }

        public void onNext(T t) {
            ++this.emitted;
            this.downstream.onNext(t);
        }

        @Override
        public void onComplete() {
            if (this.wip.getAndIncrement() == 0) {
                Publisher<? extends T>[] a = this.upstreams;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.currentIndex;
                    if (i == a.length) {
                        this.downstream.onComplete();
                        return;
                    }
                    Publisher<? extends T> p = a[i];
                    long c = this.emitted;
                    if (c != 0L) {
                        this.emitted = 0L;
                        this.emitted(c);
                    }
                    p.subscribe((Subscriber)this);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.currentIndex = ++i;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

