/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.DrainUtils;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiBufferOp<T>
extends AbstractMultiOperator<T, List<T>> {
    private final int size;
    private final int skip;
    private final Supplier<List<T>> supplier;

    public MultiBufferOp(Multi<? extends T> upstream, int size, int skip) {
        super(upstream);
        this.size = ParameterValidation.positive(size, "size");
        this.skip = ParameterValidation.positive(skip, "size");
        this.supplier = () -> new ArrayList(size);
    }

    @Override
    public void subscribe(Subscriber<? super List<T>> downstream) {
        if (this.size == this.skip) {
            this.upstream.subscribe(new BufferExactProcessor<T>(downstream, this.size, this.supplier));
        } else if (this.skip > this.size) {
            this.upstream.subscribe(new BufferSkipProcessor<T>(downstream, this.size, this.skip, this.supplier));
        } else {
            this.upstream.subscribe(new BufferOverlappingProcessor<T>(downstream, this.size, this.skip, this.supplier));
        }
    }

    static final class BufferOverlappingProcessor<T>
    extends MultiOperatorProcessor<T, List<T>> {
        private final Supplier<List<T>> supplier;
        private final int size;
        private final int skip;
        long index;
        long produced;
        private final AtomicBoolean firstRequest = new AtomicBoolean();
        private final AtomicLong requested = new AtomicLong();
        private final ArrayDeque<List<T>> queue = new ArrayDeque();

        BufferOverlappingProcessor(Subscriber<? super List<T>> downstream, int size, int skip, Supplier<List<T>> supplier) {
            super(downstream);
            this.size = size;
            this.skip = skip;
            this.supplier = supplier;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                return;
            }
            if (DrainUtils.postCompleteRequest(n, this.downstream, this.queue, this.requested, this::isCancelled)) {
                return;
            }
            if (this.firstRequest.compareAndSet(false, true)) {
                long u = Subscriptions.multiply(this.skip, n - 1L);
                long r = Subscriptions.add(this.size, u);
                super.request(r);
            } else {
                long r = Subscriptions.multiply(this.skip, n);
                super.request(r);
            }
        }

        public void onNext(T item) {
            List<T> b;
            if (this.isDone()) {
                return;
            }
            long i = this.index;
            if (i % (long)this.skip == 0L) {
                b = this.supplier.get();
                this.queue.offer(b);
            }
            if ((b = this.queue.peek()) != null && b.size() + 1 == this.size) {
                this.queue.poll();
                b.add(item);
                this.downstream.onNext(b);
                ++this.produced;
            }
            for (List<T> l : this.queue) {
                l.add(item);
            }
            this.index = i + 1L;
        }

        @Override
        public void onError(Throwable t) {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.downstream.onError(t);
            }
        }

        @Override
        public void onComplete() {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                long p = this.produced;
                if (p != 0L) {
                    Subscriptions.produced(this.requested, p);
                }
                DrainUtils.postComplete(this.downstream, this.queue, this.requested, this::isCancelled);
            }
        }
    }

    static final class BufferSkipProcessor<T>
    extends MultiOperatorProcessor<T, List<T>> {
        private final Supplier<List<T>> supplier;
        private final int size;
        private final int skip;
        private List<T> current;
        private long index;
        private final AtomicInteger wip = new AtomicInteger();

        BufferSkipProcessor(Subscriber<? super List<T>> downstream, int size, int skip, Supplier<List<T>> supplier) {
            super(downstream);
            this.size = size;
            this.skip = skip;
            this.supplier = supplier;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                return;
            }
            if (this.wip.compareAndSet(0, 1)) {
                long u = Subscriptions.multiply(n, this.size);
                long v = Subscriptions.multiply((long)this.skip - (long)this.size, n - 1L);
                super.request(Subscriptions.add(u, v));
            } else {
                super.request(Subscriptions.multiply(this.skip, n));
            }
        }

        public void onNext(T item) {
            if (this.isDone()) {
                return;
            }
            List<T> buffer = this.current;
            long i = this.index;
            if (i % (long)this.skip == 0L) {
                buffer = this.supplier.get();
                this.current = buffer;
            }
            if (buffer != null) {
                buffer.add(item);
                if (buffer.size() == this.size) {
                    this.current = null;
                    this.downstream.onNext(buffer);
                }
            }
            this.index = i + 1L;
        }

        @Override
        public void onError(Throwable t) {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                this.current = null;
                this.downstream.onError(t);
            }
        }

        @Override
        public void onComplete() {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                List<T> buffer = this.current;
                this.current = null;
                if (buffer != null) {
                    this.downstream.onNext(buffer);
                }
                this.downstream.onComplete();
            }
        }
    }

    static final class BufferExactProcessor<T>
    extends MultiOperatorProcessor<T, List<T>> {
        private final Supplier<List<T>> supplier;
        private final int size;
        private List<T> current;

        BufferExactProcessor(Subscriber<? super List<T>> downstream, int size, Supplier<List<T>> supplier) {
            super(downstream);
            this.size = size;
            this.supplier = supplier;
        }

        @Override
        public void request(long n) {
            Subscription subscription;
            if (n > 0L && (subscription = (Subscription)this.upstream.get()) != Subscriptions.CANCELLED) {
                subscription.request(Subscriptions.multiply(n, this.size));
            }
        }

        public void onNext(T t) {
            if (this.isDone()) {
                return;
            }
            if (this.current == null) {
                this.current = this.supplier.get();
            }
            this.current.add(t);
            if (this.current.size() == this.size) {
                List<T> buffer = this.current;
                this.current = null;
                this.downstream.onNext(buffer);
            }
        }

        @Override
        public void onComplete() {
            Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                List<T> buffer = this.current;
                if (buffer != null && !buffer.isEmpty()) {
                    this.downstream.onNext(buffer);
                }
                this.downstream.onComplete();
            }
        }
    }
}

