/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.MultiDistinctOp;
import io.smallrye.mutiny.operators.multi.MultiDistinctUntilChangedOp;
import io.smallrye.mutiny.operators.multi.MultiSkipLastOp;
import io.smallrye.mutiny.operators.multi.MultiSkipOp;
import io.smallrye.mutiny.operators.multi.MultiSkipUntilOp;
import io.smallrye.mutiny.operators.multi.MultiSkipUntilPublisherOp;
import io.smallrye.mutiny.operators.multi.MultiTakeLastOp;
import io.smallrye.mutiny.operators.multi.MultiTakeOp;
import io.smallrye.mutiny.operators.multi.MultiTakeUntilOtherOp;
import io.smallrye.mutiny.operators.multi.MultiTakeWhileOp;
import java.time.Duration;
import java.util.function.Predicate;

public class MultiTransformation {
    private MultiTransformation() {
    }

    public static <T> Multi<T> skipFirst(Multi<T> upstream, long number) {
        return new MultiSkipOp<T>(upstream, number);
    }

    public static <T> Multi<T> skipLast(Multi<T> upstream, int number) {
        return new MultiSkipLastOp<T>(upstream, number);
    }

    public static <T> Multi<T> skipForDuration(Multi<T> upstream, Duration duration) {
        Multi<Long> ticks = Multi.createFrom().ticks().startingAfter(duration).every(duration);
        return new MultiSkipUntilPublisherOp<T, Long>(upstream, ticks);
    }

    public static <T> Multi<T> skipWhile(Multi<T> upstream, Predicate<? super T> predicate) {
        return new MultiSkipUntilOp<T>(upstream, predicate);
    }

    public static <T> Multi<T> takeFirst(Multi<T> upstream, long number) {
        return new MultiTakeOp<T>(upstream, number);
    }

    public static <T> Multi<T> takeLast(Multi<T> upstream, int number) {
        return new MultiTakeLastOp<T>(upstream, number);
    }

    public static <T> Multi<T> takeForDuration(Multi<T> upstream, Duration duration) {
        Multi<Long> ticks = Multi.createFrom().ticks().startingAfter(duration).every(duration);
        return new MultiTakeUntilOtherOp<T, Long>(upstream, ticks);
    }

    public static <T> Multi<T> takeWhile(Multi<T> upstream, Predicate<? super T> predicate) {
        return new MultiTakeWhileOp<T>(upstream, predicate);
    }

    public static <T> Multi<T> distinct(Multi<T> upstream) {
        return new MultiDistinctOp<T>(upstream);
    }

    public static <T> Multi<T> dropRepetitions(Multi<T> upstream) {
        return new MultiDistinctUntilChangedOp<T>(upstream);
    }
}

