/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiSwitchOnEmptyOp;
import io.smallrye.mutiny.operators.multi.builders.FailedMulti;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiSwitchOnEmpty<T>
extends MultiOperator<T, T> {
    private final Supplier<Publisher<? extends T>> supplier;

    public MultiSwitchOnEmpty(Multi<T> upstream, Supplier<Publisher<? extends T>> supplier) {
        super(upstream);
        this.supplier = supplier;
    }

    @Override
    protected Publisher<T> publisher() {
        Supplier<Multi> actual = () -> {
            Publisher<? extends T> publisher;
            try {
                publisher = this.supplier.get();
            }
            catch (Exception e) {
                return new FailedMulti(e);
            }
            if (publisher == null) {
                return new FailedMulti(new NullPointerException("The supplier returned `null`"));
            }
            if (publisher instanceof Multi) {
                return (Multi)publisher;
            }
            return Multi.createFrom().publisher(publisher);
        };
        Multi deferred = Multi.createFrom().deferred(actual);
        return new MultiSwitchOnEmptyOp(this.upstream(), deferred);
    }
}

