/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.builders.CollectionBasedMulti;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class MultiCombine {
    private MultiCombine() {
    }

    public static <T> Multi<T> merge(List<Publisher<T>> participants, boolean collectFailures, int requests, int concurrency) {
        List<Publisher<T>> candidates = ParameterValidation.doesNotContainNull(participants, "participants");
        if (collectFailures) {
            return new CollectionBasedMulti<Publisher<T>>(candidates).onItem().produceMulti(Function.identity()).collectFailures().withRequests(requests).merge(concurrency);
        }
        return new CollectionBasedMulti<Publisher<T>>(candidates).onItem().produceMulti(Function.identity()).withRequests(requests).merge(concurrency);
    }
}

