/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.UniAndGroup;
import io.smallrye.mutiny.groups.UniAwait;
import io.smallrye.mutiny.groups.UniCombine;
import io.smallrye.mutiny.groups.UniConvert;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniIfNoItem;
import io.smallrye.mutiny.groups.UniOnEvent;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.groups.UniOr;
import io.smallrye.mutiny.groups.UniSubscribe;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Tuple2;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Uni<T> {
    public static UniCreate createFrom() {
        return UniCreate.INSTANCE;
    }

    default public <O> O then(Function<Uni<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    public static UniCombine combine() {
        return UniCombine.INSTANCE;
    }

    public UniSubscribe<T> subscribe();

    default public CompletableFuture<T> subscribeAsCompletionStage() {
        return this.subscribe().asCompletionStage();
    }

    public UniAwait<T> await();

    public UniOnItem<T> onItem();

    public UniAndGroup<T> and();

    public <T2> Uni<Tuple2<T, T2>> and(Uni<T2> var1);

    public UniOr or();

    public UniOnFailure<T> onFailure();

    public UniOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    public UniOnFailure<T> onFailure(Class<? extends Throwable> var1);

    public UniIfNoItem<T> ifNoItem();

    public Uni<T> emitOn(Executor var1);

    public Uni<T> subscribeOn(Executor var1);

    public Uni<T> cache();

    default public <O> Uni<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().apply(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public <O> Uni<O> flatMap(Function<? super T, Uni<? extends O>> mapper) {
        return this.onItem().produceUni(ParameterValidation.nonNull(mapper, "mapper"));
    }

    public UniConvert<T> convert();

    public Multi<T> toMulti();

    public UniOnEvent<T> on();
}

