/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class FailedMulti<T>
extends AbstractMulti<T> {
    private final Supplier<Throwable> supplier;

    public FailedMulti(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        this.supplier = () -> failure;
    }

    public FailedMulti(Supplier<Throwable> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        this.supplier = supplier;
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        try {
            Throwable throwable = this.supplier.get();
            if (throwable == null) {
                Subscriptions.fail(actual, new NullPointerException("The supplier returned `null`"));
            } else {
                Subscriptions.fail(actual, throwable);
            }
        }
        catch (Exception e) {
            Subscriptions.fail(actual, e);
        }
    }
}

