/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class DeferredMulti<T>
extends AbstractMulti<T> {
    private final Supplier<? extends Publisher<? extends T>> supplier;

    public DeferredMulti(Supplier<? extends Publisher<? extends T>> supplier) {
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        Publisher<? extends T> publisher;
        try {
            publisher = this.supplier.get();
            if (publisher == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
        }
        catch (Throwable failure) {
            Subscriptions.fail(downstream, failure);
            return;
        }
        publisher.subscribe(downstream);
    }
}

