/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class MultiOperatorProcessor<I, O>
implements Subscriber<I>,
Subscription {
    protected final Subscriber<? super O> downstream;
    protected AtomicReference<Subscription> upstream = new AtomicReference();
    AtomicBoolean hasDownstreamCancelled = new AtomicBoolean();

    public MultiOperatorProcessor(Subscriber<? super O> downstream) {
        this.downstream = ParameterValidation.nonNull(downstream, "downstream");
    }

    void failAndCancel(Throwable throwable) {
        Subscription subscription = this.upstream.get();
        if (subscription != null) {
            subscription.cancel();
        }
        this.onError(throwable);
    }

    protected boolean isDone() {
        return this.upstream.get() == Subscriptions.CANCELLED;
    }

    protected boolean isCancelled() {
        return this.hasDownstreamCancelled.get();
    }

    public void onSubscribe(Subscription subscription) {
        if (this.upstream.compareAndSet(null, subscription)) {
            this.downstream.onSubscribe((Subscription)this);
        } else {
            subscription.cancel();
        }
    }

    public void onError(Throwable throwable) {
        Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onError(throwable);
        }
    }

    public void onComplete() {
        Subscription subscription = this.upstream.getAndSet(Subscriptions.CANCELLED);
        if (subscription != Subscriptions.CANCELLED) {
            this.downstream.onComplete();
        }
    }

    public void request(long numberOfItems) {
        Subscription subscription = this.upstream.get();
        if (subscription != Subscriptions.CANCELLED) {
            if (numberOfItems <= 0L) {
                this.onError(new IllegalArgumentException("Invalid number of request, must be greater than 0"));
            }
            subscription.request(numberOfItems);
        }
    }

    public void cancel() {
        if (this.hasDownstreamCancelled.compareAndSet(false, true)) {
            Subscriptions.cancel(this.upstream);
        }
    }
}

